
CREATE TABLE IF NOT EXISTS `batch_task`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `task_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '当前任务类型',
  `task_node` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '当前自定义任务节点',
  `rpt_call_ind` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否允许重复执行',
  `sts` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '状态（00初始化，10待处理，20处理中，30异常，40完成）',
  `abnorm_rsn_cd` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '异常原因码',
  `abnorm_rsn_desc` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '异常原因描述',
  `exe_cnt` bigint(10) NULL DEFAULT NULL COMMENT '执行次数',
  `pri` bigint(10) NULL DEFAULT NULL COMMENT '优先级',
  `log_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '日志ID',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  PRIMARY KEY (`id`) USING BTREE
) COMMENT = '批处理任务' ;

-- ----------------------------
-- Table structure for batch_task_data_ref
-- ----------------------------
CREATE TABLE IF NOT EXISTS `batch_task_data_ref`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `task_id` bigint(32) NULL DEFAULT NULL COMMENT '任务ID',
  `table_id` bigint(32) NULL DEFAULT NULL COMMENT '表id',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  PRIMARY KEY (`id`) USING BTREE
) COMMENT = '批处理任务数据关联表' ;

-- ----------------------------
-- Table structure for batch_task_his
-- ----------------------------
CREATE TABLE IF NOT EXISTS `batch_task_his`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `task_id` bigint(32) NULL DEFAULT NULL COMMENT '任务ID',
  `task_type` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '当前任务类型',
  `task_node` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '当前自定义任务节点',
  `rpt_call_ind` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否允许重复执行',
  `sts` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '状态（00初始化，10待处理，20处理中，30异常，40完成）',
  `abnorm_rsn_cd` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '异常原因码',
  `abnorm_rsn_desc` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '异常原因描述',
  `exe_cnt` bigint(10) NULL DEFAULT NULL COMMENT '执行次数',
  `pri` bigint(10) NULL DEFAULT NULL COMMENT '优先级',
  `log_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '日志ID',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  PRIMARY KEY (`id`) USING BTREE
) COMMENT = '批处理任务历史表' ;

-- ----------------------------
-- Table structure for com_city_code
-- ----------------------------
CREATE TABLE IF NOT EXISTS `com_city_code`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `area_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '区域名称',
  `area_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '区域代码',
  `area_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '区域类型',
  `short_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '区域简称',
  `english_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '英文名称',
  `area_level` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '区域等级',
  `pid` bigint(20) NOT NULL COMMENT '上级ID',
  `area_status` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '地址状态',
  `area_spell` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '汉语拼音',
  `area_shspell` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '拼音首字母',
  `tel_head` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '区号',
  `zip_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '邮编',
  `area_desc` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '区域描述',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `uk_area_area_code`(`area_code`) USING BTREE,
  INDEX `idx_area_pid`(`pid`) USING BTREE,
  INDEX `idx_area_area_name`(`area_name`) USING BTREE
) COMMENT = '区域定义' ;

-- ----------------------------
-- Table structure for com_currency
-- ----------------------------
CREATE TABLE IF NOT EXISTS `com_currency`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `ou_id` bigint(20) NULL DEFAULT NULL COMMENT '公司ID',
  `curr_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '币种编号',
  `curr_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '币种名称',
  `disp_decimal` int(11) NULL DEFAULT NULL COMMENT '显示小数位数',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `uk_curr_code`(`curr_code`) USING BTREE
) COMMENT = '币种' ;

-- ----------------------------
-- Table structure for com_file
-- ----------------------------
CREATE TABLE IF NOT EXISTS `com_file`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  `file_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '文件编码，文件服务器上的文件唯一标识',
  `original_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '文件原名称',
  `file_size` bigint(20) NULL DEFAULT NULL COMMENT '文件大小，字节B',
  `suffix` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '文件名后缀',
  `mime_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '文件内容类型，mime-type',
  `file_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '常见的文件类型（IMAGE-图片，AUDIO-音频，VIDEO-视频），为空则表示不常见',
  `upload_time` datetime(6) NULL DEFAULT NULL COMMENT '上传时间',
  `width` int(11) NULL DEFAULT NULL COMMENT '宽度，图片时有值',
  `height` int(11) NULL DEFAULT NULL COMMENT '高度，图片时有值',
  `url_preview` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '文件预览url',
  `url_download` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '文件下载url',
  `url_delete` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '文件删除url',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE,
  INDEX `sec_bu_id_index`(`sec_bu_id`) USING BTREE,
  INDEX `sec_user_id_index`(`sec_user_id`) USING BTREE,
  INDEX `sec_ou_id_index`(`sec_ou_id`) USING BTREE
) COMMENT = '文件上传记录' ;

-- ----------------------------
-- Table structure for com_tax_rate
-- ----------------------------
CREATE TABLE IF NOT EXISTS `com_tax_rate`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  `ou_id` bigint(20) NULL DEFAULT NULL COMMENT '公司ID',
  `tax_rate_no` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '税率编号',
  `tax_rate_desc` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '税率说明',
  `valid_from` datetime(0) NULL DEFAULT NULL COMMENT '生效日期',
  `valid_to` datetime(0) NULL DEFAULT NULL COMMENT '失效日期',
  `tax_rate_value` float(20, 8) NULL DEFAULT NULL COMMENT '税率值',
  `tax_rate_index` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '税率索引 [UOM]COM:TAX_RATE_INDEX',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE
) COMMENT = '税率' ;

-- ----------------------------
-- Table structure for common_org_bu_treed
-- ----------------------------
CREATE TABLE IF NOT EXISTS `common_org_bu_treed`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `pid` bigint(20) NOT NULL COMMENT '上级ID',
  `sort_no` int(11) NULL DEFAULT NULL COMMENT '排序号',
  `level` int(11) NULL DEFAULT NULL COMMENT '层级',
  `code_path` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '树型结构编号全路径，使用/隔离',
  `bu_tree_id` bigint(20) NULL DEFAULT NULL COMMENT '组织树ID',
  `bu_id` bigint(20) NULL DEFAULT NULL COMMENT '组织ID',
  `bu_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_bu_tree_pid`(`pid`) USING BTREE,
  INDEX `idx_bu_tree_code_path`(`code_path`) USING BTREE
) COMMENT = '组织树明细' ;

-- ----------------------------
-- Table structure for dep_info
-- ----------------------------
CREATE TABLE IF NOT EXISTS `dep_info`  (
  `dep_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '组织机构名称',
  `dep_code` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '组织机构代码',
  `dep_id` bigint(20) NULL DEFAULT NULL COMMENT '组织机构ID',
  `parent_dep_id` bigint(20) NULL DEFAULT NULL COMMENT '父组织ID',
  `dep_address` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '组织机构地址',
  `dep_tel` bigint(20) NULL DEFAULT NULL COMMENT '组织机构电话',
  `dep_mail` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '组织机构邮箱',
  `dep_type` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '机构类型',
  `status` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '数据状态',
  `start_time` datetime(0) NULL DEFAULT NULL COMMENT '有效日期自',
  `end_time` datetime(0) NULL DEFAULT NULL COMMENT '有效日期自',
  `crt_date` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `crt_name` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `lstupdt_date` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  `lstupdt_name` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `attribute1` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '扩展字段1',
  `attribute2` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '扩展字段2',
  `attribute3` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '扩展字段3',
  `attribute4` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '扩展字段4',
  `attribute5` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '扩展字段5',
  `attribute6` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '扩展字段6',
  `attribute7` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '扩展字段7',
  `attribute8` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '扩展字段8',
  `attribute9` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '扩展字段9',
  `attribute10` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '扩展字段10',
  `attribute11` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '扩展字段11',
  `attribute12` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '扩展字段12',
  `attribute13` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '扩展字段13',
  `attribute14` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '扩展字段14',
  `attribute15` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '扩展字段15',
  `attribute16` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '扩展字段16',
  `attribute17` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '扩展字段17',
  `attribute18` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '扩展字段18',
  `attribute19` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '扩展字段19',
  `attribute20` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '扩展字段20',
  `cg_dept_path` varchar(800) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '部门路径',
  `dep_s_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '简短描述',
  `setid` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '集合id',
  `cg_gint_dept_level` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '集团内部级别',
  `cg_dept_sort` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '本公司内部门排序',
  `cg_dept_cmp_lvl` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '本公司内部门层级',
  `cg_dept_area` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '所属区域',
  `dept_id` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '部门id',
  `effdt` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '生效日期',
  `eff_status` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '生效状态 A：有效，I：无效',
  `descrshort` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '简短描述',
  `descr` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '长描述',
  `cg_dept_type` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '部门类别',
  `cg_dept_parent` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '上级部门',
  `company` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '公司ID',
  `company_descr` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '公司名称',
  `cg_is_company` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '判定该部门是否为公司',
  `cg_dept_manager_id` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '部门分管领导员工ID',
  `cg_dept_virtual` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '是否虚拟部门',
  `setid_dept` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `deptid2` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '分管领导所在部门',
  `descr2` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `setid_location` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '地点集合 ID',
  `location` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '地点代码',
  `manager_id` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '管理员 ID',
  `cg_man_jbcd_descr` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `cg_dept_addr` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '详细地址',
  `lastupddttm` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '上次更新时间货日期(PS)',
  `uuid` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'UUID',
  PRIMARY KEY (`dept_id`) USING BTREE,
  INDEX `index_name`(`dept_id`) USING BTREE
) COMMENT = '组织机构表' ;

-- ----------------------------
-- Table structure for emp_dep_relationship
-- ----------------------------
CREATE TABLE IF NOT EXISTS `emp_dep_relationship`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '人员接口表id',
  `empl_id` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '人员ID',
  `empl_rcd` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '员工记录 0：主岗，非0：兼岗',
  `effdt` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '生效日期',
  `effseq` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '生效序号',
  `company` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '公司',
  `company_descr` varchar(300) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '公司描述',
  `deptid0` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '单位',
  `cg_deptid_descr0` varchar(300) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '单位描述',
  `cg_corp_company` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '法人公司',
  `gp_company_descr` varchar(300) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '公司描述',
  `setid_dept` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '部门集合 ID',
  `dept_id` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '部门',
  `deptid_descr` varchar(300) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '部门描述',
  `cux_company_area` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '公司段',
  `cux_cost_center` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '成本中心',
  `setid_jobcode` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '职务代码集合 ID',
  `jobcode` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '职务代码',
  `jobcode_descr` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '职务描述',
  `cg_jobcode_descr` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '职务备注',
  `empl_class` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '员工分类',
  `hr_status` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'HR 状态',
  `UUID` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'uuid',
  `status` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '数据状态',
  `creator` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '创建人',
  `create_time` datetime(0) NOT NULL COMMENT '创建时间',
  `modifier` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '最新更新人',
  `modify_time` datetime(0) NOT NULL COMMENT '最新更新时间',
  `attribute1` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '扩展字段1',
  `attribute2` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '扩展字段2',
  `attribute3` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '扩展字段3',
  `attribute4` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '扩展字段4',
  `attribute5` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '扩展字段5',
  `attribute6` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '扩展字段6',
  `attribute7` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '扩展字段7',
  `attribute8` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '扩展字段8',
  `attribute9` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '扩展字段9',
  `attribute10` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '扩展字段10',
  `attribute11` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '扩展字段11',
  `attribute12` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '扩展字段12',
  `attribute13` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '扩展字段13',
  `attribute14` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '扩展字段14',
  `attribute15` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '扩展字段15',
  `attribute16` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '扩展字段16',
  `attribute17` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '扩展字段17',
  `attribute18` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '扩展字段18',
  `attribute19` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '扩展字段19',
  `attribute20` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '扩展字段20',
  `source` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `empl_id`(`empl_id`, `empl_rcd`) USING BTREE
) COMMENT = '人员职务信息表' ;

-- ----------------------------
-- Table structure for emp_info
-- ----------------------------
CREATE TABLE IF NOT EXISTS `emp_info`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '人员主键ID',
  `emp_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '人员名称',
  `emp_id` bigint(20) UNSIGNED NOT NULL COMMENT '人员id',
  `emp_no` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'PS账号',
  `pst_name` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '岗位名称',
  `pst_id` bigint(20) NULL DEFAULT NULL COMMENT '岗位ID',
  `dep_name` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '组织机构名称',
  `dep_code` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '组织机构代码',
  `dep_id` bigint(20) NULL DEFAULT NULL COMMENT '组织机构ID',
  `org_name` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '所属公司名称',
  `org_code` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '所属公司代码',
  `org_id` bigint(20) NULL DEFAULT NULL COMMENT '所属公司ID',
  `ident_type` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '身份证' COMMENT '身份类型',
  `ident_id` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '身份号码',
  `gender` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '性别',
  `mobile` varchar(300) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '移动电话',
  `e_mail` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '电子邮件',
  `address` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '地址',
  `born_year` date NULL DEFAULT NULL COMMENT '出生年月日',
  `status` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '新增' COMMENT '数据状态',
  `start_time` datetime(0) NULL DEFAULT NULL COMMENT '有效日期自',
  `end_time` datetime(0) NULL DEFAULT NULL COMMENT '有效日期自',
  `crt_date` datetime(0) NOT NULL COMMENT '创建时间',
  `crt_name` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '创建人',
  `lstupdt_date` datetime(0) NOT NULL COMMENT '更新时间',
  `lstupdt_name` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '更新人',
  `attribute1` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '扩展字段1',
  `attribute2` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '扩展字段2',
  `attribute3` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '扩展字段3',
  `attribute4` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '扩展字段4',
  `attribute5` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '扩展字段5',
  `attribute6` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '扩展字段6',
  `attribute7` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '扩展字段7',
  `attribute8` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '扩展字段8',
  `attribute9` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '扩展字段9',
  `attribute10` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '扩展字段10',
  `attribute11` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '扩展字段11',
  `attribute12` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '扩展字段12',
  `attribute13` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '扩展字段13',
  `attribute14` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '扩展字段14',
  `attribute15` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '扩展字段15',
  `attribute16` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '扩展字段16',
  `attribute17` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '扩展字段17',
  `attribute18` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '扩展字段18',
  `attribute19` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '扩展字段19',
  `attribute20` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '扩展字段20',
  `hr_status` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'HR 状态',
  `mar_status` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '婚姻状况',
  `cg_fertly_status` varchar(2) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '生育状况',
  `hire_dt` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '首次雇用日期',
  `cg_ter_dt` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '离职日期',
  `start_dt_chn` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '职业生涯开始日期',
  `cg_join_chngas_dt` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '加入中燃日期',
  `cg_join_company_dt` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '加入本公司日期',
  `cg_adj_anle_mons` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '\r\n年假调整月',
  `cg_forw_dt` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '转正日期',
  `reg_region` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '管理区域',
  `ethnic_grp_cd` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '民族',
  `birthdate` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '出生日期',
  `data_type` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '数据状态',
  `data_version` varchar(300) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '版本号',
  `middle_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '姓名全拼',
  `pswd` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '初始密码',
  `emp_class` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '员工类型',
  `emp_class_desc` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '员工类型描述',
  `pst_code` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '岗位代码',
  `emp_uuid` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'uuid',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  `last_upddttm` datetime(0) NULL DEFAULT NULL COMMENT '上次更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `index_name`(`emp_id`) USING BTREE
) COMMENT = '人员信息表' ;

-- ----------------------------
-- Table structure for flyway_schema_history
-- ----------------------------
CREATE TABLE IF NOT EXISTS `flyway_schema_history`  (
  `installed_rank` int(11) NOT NULL,
  `version` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `description` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `script` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `checksum` int(11) NULL DEFAULT NULL,
  `installed_by` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `installed_on` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0),
  `execution_time` int(11) NOT NULL,
  `success` tinyint(1) NOT NULL,
  PRIMARY KEY (`installed_rank`) USING BTREE,
  INDEX `flyway_schema_history_s_idx`(`success`) USING BTREE
) ;

-- ----------------------------
-- Table structure for itm_brand
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_brand`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  `brand_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '品牌编码',
  `brand_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '品牌名称',
  `brand_en_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '品牌英文名',
  `brand_initial` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '品牌首字母',
  `brand_agent` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '品牌代理商',
  `file_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '品牌Logo文件编号',
  `original_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '品牌Logo文件名称',
  `brand_party` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '品牌方',
  `brand_authorized` int(11) NULL DEFAULT NULL COMMENT '品牌授权（0：否，1：是）',
  `brand_authorized_start_time` datetime(6) NULL DEFAULT NULL COMMENT '品牌授权开始时间',
  `brand_authorized_end_time` datetime(6) NULL DEFAULT NULL COMMENT '品牌授权结束时间',
  `status` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '品牌名称',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  `url` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '图片url',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `ux_brand_code`(`brand_code`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE,
  INDEX `sec_bu_id_index`(`sec_bu_id`) USING BTREE,
  INDEX `sec_user_id_index`(`sec_user_id`) USING BTREE,
  INDEX `sec_ou_id_index`(`sec_ou_id`) USING BTREE
) COMMENT = '品牌' ;

-- ----------------------------
-- Table structure for itm_cate_contr_para
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_cate_contr_para`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  `item_cate_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '品类编码',
  `param_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '管控参数编号',
  `param_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '管控参数名称',
  `param_value` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '参数值',
  `sort_no` int(11) NULL DEFAULT NULL COMMENT '排序',
  `status` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '状态',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  `price_group` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '产品段值码',
  `price_group2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT ' 财务商品分类码',
  `price_group3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '费用类码',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE,
  INDEX `sec_bu_id_index`(`sec_bu_id`) USING BTREE,
  INDEX `sec_user_id_index`(`sec_user_id`) USING BTREE,
  INDEX `sec_ou_id_index`(`sec_ou_id`) USING BTREE
) COMMENT = '品类管控参数' ;

-- ----------------------------
-- Table structure for itm_cate_prop
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_cate_prop`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  `item_cate_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '品类编码',
  `cate_prop_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '属性名编码',
  `cate_prop_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '属性名名称',
  `cate_prop_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '属性类型',
  `is_box` int(11) NULL DEFAULT NULL COMMENT '单选复选(0:单选,1:复选)',
  `is_hand` int(11) NULL DEFAULT NULL COMMENT '录入方式(0:列表选择,1:手动输入)',
  `is_must` int(11) NULL DEFAULT NULL COMMENT '是否必填(0:否,1:是)',
  `is_sku` int(11) NULL DEFAULT NULL COMMENT '是否和SKU相关(0:否,1:是)',
  `sort_no` int(11) NULL DEFAULT NULL COMMENT '排序号',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE,
  INDEX `sec_bu_id_index`(`sec_bu_id`) USING BTREE,
  INDEX `sec_user_id_index`(`sec_user_id`) USING BTREE,
  INDEX `sec_ou_id_index`(`sec_ou_id`) USING BTREE
) COMMENT = '品类属性key表' ;

-- ----------------------------
-- Table structure for itm_cate_prop_value
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_cate_prop_value`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  `cate_prop_id` bigint(20) NULL DEFAULT NULL COMMENT '属性名ID',
  `prop_value_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '属性值编码',
  `prop_value_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '属性值名称',
  `prop_value_rank` int(11) NULL DEFAULT NULL COMMENT '属性值排序',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE,
  INDEX `sec_bu_id_index`(`sec_bu_id`) USING BTREE,
  INDEX `sec_user_id_index`(`sec_user_id`) USING BTREE,
  INDEX `sec_ou_id_index`(`sec_ou_id`) USING BTREE
) COMMENT = '品类属性value表' ;

-- ----------------------------
-- Table structure for itm_combo_d
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_combo_d`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  `item_combo_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '组合商品编码',
  `item_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品编码',
  `status` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '状态',
  `qty` decimal(20, 8) NULL DEFAULT NULL COMMENT '数量',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE,
  INDEX `sec_bu_id_index`(`sec_bu_id`) USING BTREE,
  INDEX `sec_user_id_index`(`sec_user_id`) USING BTREE,
  INDEX `sec_ou_id_index`(`sec_ou_id`) USING BTREE
) COMMENT = '组合商品明细' ;

-- ----------------------------
-- Table structure for itm_combo_tag
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_combo_tag`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  `item_combo_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '组合商品编码',
  `tag_cate_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '标签分类编码',
  `tag_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '标签编码',
  `status` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '状态',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE,
  INDEX `sec_bu_id_index`(`sec_bu_id`) USING BTREE,
  INDEX `sec_user_id_index`(`sec_user_id`) USING BTREE,
  INDEX `sec_ou_id_index`(`sec_ou_id`) USING BTREE
) COMMENT = '组合商品标签' ;

-- ----------------------------
-- Table structure for itm_item
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_item`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  `ou_id` bigint(20) NULL DEFAULT NULL COMMENT '公司ID',
  `ou_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '公司编号',
  `ou_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '公司名称',
  `bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'BU ID',
  `bu_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'BU编号',
  `bu_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'BU名称',
  `item_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品编号',
  `item_code2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品编号2',
  `item_code3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品编号3',
  `item_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品名称',
  `item_name2` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品名称2',
  `item_name3` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品名称3',
  `item_abbr` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品简称',
  `item_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品类型 [UDC]ITM:ITEM_TYPE',
  `item_type2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品类型2 [UDC]ITM:ITEM_TYPE2',
  `item_type3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品类型3',
  `item_type4` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品类型4',
  `item_type5` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品类型5',
  `item_status` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品状态 [UDC]ITM:ITEM_STATUS',
  `item_status2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品状态2',
  `item_status3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品状态3',
  `spec` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '规格，比如：食品净含量',
  `spu_id` bigint(20) NOT NULL COMMENT 'SPU_ID',
  `spu_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SPU_CODE',
  `spu_code2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SPU_CODE2',
  `spu_code3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SPU_CODE3',
  `spu_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SPU_NAME',
  `spu_name2` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SPU_NAME2',
  `spu_name3` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SPU_NAME3',
  `spu_abbr` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SPU简称',
  `item_attr` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品规格',
  `item_attr2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品规格2',
  `item_attr3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品规格3',
  `item_attr4` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品规格4',
  `item_attr5` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品规格5',
  `item_cate_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品品类编号',
  `item_cate_code2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品品类编号2',
  `item_cate_code3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品品类编号3',
  `item_source` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品识别号',
  `brand` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '品牌',
  `brand2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '品牌2',
  `salepurc_flag` int(11) NULL DEFAULT NULL COMMENT '是否允许自采',
  `sn_flag` int(11) NULL DEFAULT NULL COMMENT '是否启用序列号',
  `lot_flag` int(11) NULL DEFAULT NULL COMMENT '是否启用批次号',
  `guarantee_flag` int(11) NULL DEFAULT NULL COMMENT '效期管理标识',
  `memberdisc_flagx` int(11) NULL DEFAULT NULL COMMENT '是否享会员折扣',
  `distribution_flagx` int(11) NULL DEFAULT NULL COMMENT '是否分销',
  `fin_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '财务分类 [UDC]ITM:FIN_TYPE',
  `cost_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '成本计价方法 [UDC]ITM:COST_TYPE',
  `alloc_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '配货类型 [UDC]ITM:ALLOC_TYPE',
  `deliver_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '配送类型 [UDC]ITM:DELIVER_TYPE',
  `install_flag` int(11) NULL DEFAULT NULL COMMENT '是否需要安装',
  `return_exchange_flag` int(11) NULL DEFAULT NULL COMMENT '是否可退换货',
  `return_exchange_policy` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '退换货政策 [UDC]ITM:RETURN_EXCHANGE_POLICY',
  `warranty_flag` int(11) NULL DEFAULT NULL COMMENT '是否保修',
  `warranty_period` int(11) NULL DEFAULT NULL COMMENT '保修期时长',
  `warranty_period_unit` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '保修期单位 [UDC]COM:TIME_UNIT',
  `trans_condition` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '运输条件',
  `store_condition` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '存储条件',
  `package_spec` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '包装规格',
  `guarantee_period` int(11) NULL DEFAULT NULL COMMENT '保质期时长',
  `guarantee_period_unit` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '保质期单位 [UDC]COM:TIME_UNIT',
  `guarantee_days` int(11) NULL DEFAULT NULL COMMENT '保质期天数',
  `tax_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '税收分类码',
  `tax_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '税码(进项)',
  `tax_rate` decimal(20, 8) NULL DEFAULT NULL COMMENT '税率(进项)',
  `tax_rate_no` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '税率编号(进项)',
  `tax_code2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '税码2(销项)',
  `tax_rate2` decimal(20, 8) NULL DEFAULT NULL COMMENT '税率2(销项)',
  `tax_rate_no2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '税率编号2(销项)',
  `tax_rate_tariff` decimal(20, 8) NULL DEFAULT NULL COMMENT '关税税率',
  `supp_id` bigint(20) NULL DEFAULT NULL COMMENT '供应商ID',
  `supp_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '供应商编号',
  `supp_abbr` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '供应商简称',
  `supp_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '供应商名称',
  `supp_item_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '供应商物料编码',
  `bar_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '条码',
  `bar_code2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '条码',
  `uom` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '主计量单位 [UDC]COM:UOM',
  `uom2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '主计量单位2 [UDC]COM:UOM',
  `uom3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '主计量单位3 [UDC]COM:UOM',
  `uom4` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '主计量单位4 [UDC]COM:UOM',
  `uom5` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '主计量单位5 [UDC]COM:UOM',
  `sale_uom` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '默认销售单位 [UDC]COM:UOM',
  `purc_uom` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '默认采购单位 [UDC]COM:UOM',
  `ship_uom` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '发运计量单位 [UDC]COM:UOM',
  `order_uom` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '要货计量单位 [UDC]COM:UOM',
  `pricing_uom` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '定价计量单位 [UDC]COM:UOM',
  `store_uom` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '库存计量单位 [UDC]COM:UOM',
  `gross_weight` decimal(20, 8) NULL DEFAULT NULL COMMENT '毛重',
  `net_weight` decimal(20, 8) NULL DEFAULT NULL COMMENT '净重',
  `weight_unit` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '重量单位 [UDC]COM:WEIGHT_UNIT',
  `weight_item_uom` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '重量对应的品项单位 [UDC]COM:UOM',
  `volume` decimal(20, 8) NULL DEFAULT NULL COMMENT '体积',
  `volume_unit` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '体积单位 [UDC]COM:VOLUME_UNIT',
  `length` decimal(20, 8) NULL DEFAULT NULL COMMENT '长',
  `width` decimal(20, 8) NULL DEFAULT NULL COMMENT '宽',
  `height` decimal(20, 8) NULL DEFAULT NULL COMMENT '高',
  `length_unit` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '长度单位 [UDC]COM:LENGTH_UNIT',
  `moq` decimal(20, 8) NULL DEFAULT NULL COMMENT '最小起定量',
  `safe_qty` decimal(20, 8) NULL DEFAULT NULL COMMENT '安全库存',
  `max_order_qty` decimal(20, 8) NULL DEFAULT NULL COMMENT '最大要货量',
  `tags` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '标签',
  `outer_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '外部编号',
  `outer_code2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '外部编号2',
  `cat` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '是否第三方入驻商品 0：否  1：是  ，默认0',
  `cat2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '类别码 [UDC]ITM:ITM_CAT2',
  `cat3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码 [UDC]ITM:ITM_CAT3',
  `cat4` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码 [UDC]ITM:ITM_CAT4',
  `cat5` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码 [UDC]ITM:ITM_CAT5',
  `cat6` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码 [UDC]ITM:ITM_CAT6',
  `cat7` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码 [UDC]ITM:ITM_CAT7',
  `cat8` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码 [UDC]ITM:ITM_CAT8',
  `cat9` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码 [UDC]ITM:ITM_CAT9',
  `cat10` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码 [UDC]ITM:ITM_CAT10',
  `es1` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES1',
  `es2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES2',
  `es3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES3',
  `es4` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES4',
  `es5` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES5',
  `es6` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES6',
  `es7` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES7',
  `es8` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES8',
  `es9` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES9',
  `es10` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES10',
  `en1` decimal(20, 8) NULL DEFAULT NULL COMMENT 'EN1',
  `en2` decimal(20, 8) NULL DEFAULT NULL COMMENT 'EN2',
  `en3` decimal(20, 8) NULL DEFAULT NULL COMMENT 'EN3',
  `en4` decimal(20, 8) NULL DEFAULT NULL COMMENT 'EN4',
  `en5` decimal(20, 8) NULL DEFAULT NULL COMMENT 'EN5',
  `ed1` datetime(6) NULL DEFAULT NULL COMMENT 'ED1',
  `ed2` datetime(6) NULL DEFAULT NULL COMMENT 'ED2',
  `ed3` datetime(6) NULL DEFAULT NULL COMMENT 'ED3',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  `release_flag` int(11) NULL DEFAULT NULL COMMENT '是否发布',
  `aftersales_service_flagx` int(11) NULL DEFAULT NULL COMMENT '是否需要售后服务',
  `origin` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '产地/原产国',
  `menu_country` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '原产国',
  `manuer_id` bigint(20) NULL DEFAULT NULL COMMENT '厂家ID',
  `manuer_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '厂家名称',
  `manuer_item_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '厂家物料编码',
  `manuer_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '厂家编码',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `ux_item_code`(`item_code`) USING BTREE,
  INDEX `idx_spu_id`(`spu_id`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE,
  INDEX `sec_bu_id_index`(`sec_bu_id`) USING BTREE,
  INDEX `sec_user_id_index`(`sec_user_id`) USING BTREE,
  INDEX `sec_ou_id_index`(`sec_ou_id`) USING BTREE,
  INDEX `codex_spu_code`(`spu_code`) USING BTREE
) COMMENT = '商品' ;

-- ----------------------------
-- Table structure for itm_item_apply
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_item_apply`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'OU公司ID',
  `bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'BU组织ID',
  `doc_no` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '单据编号',
  `doc_type` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '单据类型',
  `doc_type2` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '单据类型2',
  `doc_type3` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '单据类型3',
  `doc_status` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '单据状态',
  `apply_emp_id` bigint(20) NULL DEFAULT NULL COMMENT '申请人员工ID',
  `apply_date` datetime(0) NULL DEFAULT NULL COMMENT '申请日期',
  `apply_desc` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '申请描述',
  `appr_status` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '审批状态',
  `appr_time` datetime(0) NULL DEFAULT NULL COMMENT '审批时间',
  `apply_user_id` bigint(20) NULL DEFAULT NULL COMMENT '审批人ID',
  `apply_comment` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '审批意见',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  `proc_inst_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '流程实例ID',
  `proc_inst_status` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '流程实例状态',
  `submit_time` datetime(6) NULL DEFAULT NULL COMMENT '提交时间',
  `approved_time` datetime(6) NULL DEFAULT NULL COMMENT '审批通过时间',
  PRIMARY KEY (`id`) USING BTREE
) COMMENT = '商品审核单据表' ;

-- ----------------------------
-- Table structure for itm_item_applyd
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_item_applyd`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `ou_id` bigint(20) NULL DEFAULT NULL COMMENT '公司ID',
  `doc_no` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '单据编号',
  `ou_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '公司编号',
  `ou_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '公司名称',
  `bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'BU ID',
  `bu_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'BU编号（采购组织编码）',
  `bu_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'BU名称',
  `item_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品编号',
  `item_code2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品编号2',
  `item_code3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品编号3',
  `item_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品名称',
  `item_name2` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品名称2',
  `item_name3` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品名称3',
  `item_abbr` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品简称',
  `item_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品类型 [UDC]ITM:ITEM_TYPE',
  `item_type2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品类型2 [UDC]ITM:ITEM_TYPE2',
  `item_type3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品类型3',
  `item_type4` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品类型4',
  `item_type5` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品类型5',
  `item_status` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品状态 [UDC]ITM:ITEM_STATUS',
  `item_status2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品状态2',
  `item_status3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品状态3',
  `spec` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '规格，比如：食品净含量',
  `spu_id` bigint(20) NOT NULL COMMENT 'SPU_ID',
  `spu_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SPU_CODE',
  `spu_code2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SPU_CODE2',
  `spu_code3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SPU_CODE3',
  `spu_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SPU_NAME',
  `spu_name2` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SPU_NAME2',
  `spu_name3` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SPU_NAME3',
  `spu_abbr` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SPU简称',
  `item_attr` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品规格',
  `item_attr2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品规格2',
  `item_attr3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品规格3',
  `item_attr4` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品规格4',
  `item_attr5` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品规格5',
  `item_cate_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品品类编号',
  `item_cate_code2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品品类编号2',
  `item_cate_code3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品品类编号3',
  `item_source` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品识别号',
  `brand` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '品牌',
  `brand2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '品牌2',
  `salepurc_flag` int(11) NULL DEFAULT NULL COMMENT '是否允许自采',
  `sn_flag` int(11) NULL DEFAULT NULL COMMENT '是否启用序列号',
  `lot_flag` int(11) NULL DEFAULT NULL COMMENT '是否启用批次号',
  `guarantee_flag` int(11) NULL DEFAULT NULL COMMENT '效期管理标识',
  `memberdisc_flagx` int(11) NULL DEFAULT NULL COMMENT '是否享会员折扣',
  `distribution_flagx` int(11) NULL DEFAULT NULL COMMENT '是否分销',
  `fin_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '财务分类 [UDC]ITM:FIN_TYPE',
  `cost_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '成本计价方法 [UDC]ITM:COST_TYPE',
  `alloc_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '配货类型 [UDC]ITM:ALLOC_TYPE',
  `deliver_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '配送类型 [UDC]ITM:DELIVER_TYPE',
  `install_flag` int(11) NULL DEFAULT NULL COMMENT '是否需要安装',
  `return_exchange_flag` int(11) NULL DEFAULT NULL COMMENT '是否可退换货',
  `return_exchange_policy` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '退换货政策 [UDC]ITM:RETURN_EXCHANGE_POLICY',
  `warranty_flag` int(11) NULL DEFAULT NULL COMMENT '是否保修',
  `warranty_period` int(11) NULL DEFAULT NULL COMMENT '保修期时长',
  `warranty_period_unit` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '保修期单位 [UDC]COM:TIME_UNIT',
  `trans_condition` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '运输条件',
  `store_condition` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '存储条件',
  `package_spec` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '包装规格',
  `guarantee_period` int(11) NULL DEFAULT NULL COMMENT '保质期时长',
  `guarantee_period_unit` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '保质期单位 [UDC]COM:TIME_UNIT',
  `guarantee_days` int(11) NULL DEFAULT NULL COMMENT '保质期天数',
  `tax_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '税收分类码',
  `tax_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '税码(进项)',
  `tax_rate` decimal(20, 8) NULL DEFAULT NULL COMMENT '税率(进项)',
  `tax_rate_no` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '税率编号(进项)',
  `tax_code2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '税码2(销项)',
  `tax_rate2` decimal(20, 8) NULL DEFAULT NULL COMMENT '税率2(销项)',
  `tax_rate_no2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '税率编号2(销项)',
  `tax_rate_tariff` decimal(20, 8) NULL DEFAULT NULL COMMENT '关税税率',
  `supp_id` bigint(20) NULL DEFAULT NULL COMMENT '供应商ID',
  `supp_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '供应商编号',
  `supp_abbr` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '供应商简称',
  `supp_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '供应商名称',
  `supp_item_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '供应商物料编码',
  `bar_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '条码',
  `bar_code2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '条码',
  `uom` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '主计量单位 [UDC]COM:UOM',
  `uom2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '主计量单位2 [UDC]COM:UOM',
  `uom3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '主计量单位3 [UDC]COM:UOM',
  `uom4` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '主计量单位4 [UDC]COM:UOM',
  `uom5` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '主计量单位5 [UDC]COM:UOM',
  `sale_uom` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '默认销售单位 [UDC]COM:UOM',
  `purc_uom` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '默认采购单位 [UDC]COM:UOM',
  `ship_uom` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '发运计量单位 [UDC]COM:UOM',
  `order_uom` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '要货计量单位 [UDC]COM:UOM',
  `pricing_uom` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '定价计量单位 [UDC]COM:UOM',
  `store_uom` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '库存计量单位 [UDC]COM:UOM',
  `gross_weight` decimal(20, 8) NULL DEFAULT NULL COMMENT '毛重',
  `net_weight` decimal(20, 8) NULL DEFAULT NULL COMMENT '净重',
  `weight_unit` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '重量单位 [UDC]COM:WEIGHT_UNIT',
  `weight_item_uom` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '重量对应的品项单位 [UDC]COM:UOM',
  `volume` decimal(20, 8) NULL DEFAULT NULL COMMENT '体积',
  `volume_unit` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '体积单位 [UDC]COM:VOLUME_UNIT',
  `length` decimal(20, 8) NULL DEFAULT NULL COMMENT '长',
  `width` decimal(20, 8) NULL DEFAULT NULL COMMENT '宽',
  `height` decimal(20, 8) NULL DEFAULT NULL COMMENT '高',
  `length_unit` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '长度单位 [UDC]COM:LENGTH_UNIT',
  `moq` decimal(20, 8) NULL DEFAULT NULL COMMENT '最小起定量',
  `safe_qty` decimal(20, 8) NULL DEFAULT NULL COMMENT '安全库存',
  `max_order_qty` decimal(20, 8) NULL DEFAULT NULL COMMENT '最大要货量',
  `tags` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '标签',
  `outer_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '外部编号',
  `outer_code2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '外部编号2',
  `cat` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码 [UDC]ITM:ITM_CAT',
  `cat2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码 [UDC]ITM:ITM_CAT2',
  `cat3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码 [UDC]ITM:ITM_CAT3',
  `cat4` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码 [UDC]ITM:ITM_CAT4',
  `cat5` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码 [UDC]ITM:ITM_CAT5',
  `cat6` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码 [UDC]ITM:ITM_CAT6',
  `cat7` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码 [UDC]ITM:ITM_CAT7',
  `cat8` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码 [UDC]ITM:ITM_CAT8',
  `cat9` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码 [UDC]ITM:ITM_CAT9',
  `cat10` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码 [UDC]ITM:ITM_CAT10',
  `es1` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES1',
  `es2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES2',
  `es3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES3',
  `es4` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES4',
  `es5` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES5',
  `es6` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES6',
  `es7` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES7',
  `es8` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES8',
  `es9` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES9',
  `es10` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES10',
  `en1` decimal(20, 8) NULL DEFAULT NULL COMMENT 'EN1',
  `en2` decimal(20, 8) NULL DEFAULT NULL COMMENT 'EN2',
  `en3` decimal(20, 8) NULL DEFAULT NULL COMMENT 'EN3',
  `en4` decimal(20, 8) NULL DEFAULT NULL COMMENT 'EN4',
  `en5` decimal(20, 8) NULL DEFAULT NULL COMMENT 'EN5',
  `ed1` datetime(6) NULL DEFAULT NULL COMMENT 'ED1',
  `ed2` datetime(6) NULL DEFAULT NULL COMMENT 'ED2',
  `ed3` datetime(6) NULL DEFAULT NULL COMMENT 'ED3',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  `price1` decimal(20, 8) NULL DEFAULT NULL,
  `price2` decimal(20, 8) NULL DEFAULT NULL,
  `price3` decimal(20, 8) NULL DEFAULT NULL,
  `price4` decimal(20, 8) NULL DEFAULT NULL,
  `price5` decimal(20, 8) NULL DEFAULT NULL,
  `price8` decimal(20, 8) NULL DEFAULT NULL,
  `price9` decimal(20, 8) NULL DEFAULT NULL,
  `price10` decimal(20, 8) NULL DEFAULT NULL,
  `price11` decimal(20, 8) NULL DEFAULT NULL,
  `price12` decimal(20, 8) NULL DEFAULT NULL,
  `doc_type` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '申请类型(单据类型)',
  `aftersales_service_flagx` int(11) NULL DEFAULT NULL COMMENT '是否需要售后服务',
  `origin` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '产地/原产国',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_spu_id`(`spu_id`) USING BTREE
) COMMENT = '商品履历' ;

-- ----------------------------
-- Table structure for itm_item_attachment
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_item_attachment`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  `item_id` bigint(20) NULL DEFAULT NULL COMMENT '商品ID',
  `file_id` bigint(20) NULL DEFAULT NULL COMMENT '文件ID',
  `file_name` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品文件名称',
  `file_code` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品文件编号',
  `file_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品文件类型(图片，附件等)',
  `img_size` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '图片尺寸',
  `file_size` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '文件大小',
  `major` tinyint(1) NULL DEFAULT NULL COMMENT '是否主图',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  `url` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '图片url',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE,
  INDEX `sec_bu_id_index`(`sec_bu_id`) USING BTREE,
  INDEX `sec_user_id_index`(`sec_user_id`) USING BTREE,
  INDEX `sec_ou_id_index`(`sec_ou_id`) USING BTREE
) COMMENT = '商品附件' ;

-- ----------------------------
-- Table structure for itm_item_attachment_applyd
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_item_attachment_applyd`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `item_id` bigint(20) NULL DEFAULT NULL COMMENT '商品ID',
  `file_id` bigint(20) NULL DEFAULT NULL COMMENT '文件ID',
  `file_name` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品文件名称',
  `file_code` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品文件编号',
  `file_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品文件类型(图片，附件等)',
  `img_size` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '图片尺寸',
  `file_size` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '文件大小',
  `major` tinyint(1) NULL DEFAULT NULL COMMENT '是否主图',
  `url` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '图片url',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  `doc_no` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '单据编号',
  PRIMARY KEY (`id`) USING BTREE
) COMMENT = '商品附件-履历' ;

-- ----------------------------
-- Table structure for itm_item_bom
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_item_bom`  (
  `id` bigint(20) NOT NULL,
  `sec_bu_id` bigint(20) NULL DEFAULT NULL,
  `sec_user_id` bigint(20) NULL DEFAULT NULL,
  `sec_ou_id` bigint(20) NULL DEFAULT NULL,
  `pid` bigint(20) NOT NULL,
  `sort_no` int(11) NULL DEFAULT NULL,
  `level` int(11) NULL DEFAULT NULL,
  `id_path` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `code_path` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `item_id` bigint(20) NULL DEFAULT NULL COMMENT '商品ID',
  `qty` int(11) NULL DEFAULT NULL COMMENT '数量(主计量单位的数量)',
  `general_accessories_spec` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '通用配件型号',
  `bom_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '物料类型',
  `bom_type2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '物料类型2',
  `bom_type3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '物料类型3',
  `tenant_id` bigint(20) NULL DEFAULT NULL,
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `create_user_id` bigint(20) NULL DEFAULT NULL,
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `create_time` datetime(6) NULL DEFAULT NULL,
  `modify_user_id` bigint(20) NULL DEFAULT NULL,
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `modify_time` datetime(6) NULL DEFAULT NULL,
  `delete_flag` int(11) NOT NULL,
  `audit_data_version` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE,
  INDEX `sec_bu_id_index`(`sec_bu_id`) USING BTREE,
  INDEX `sec_user_id_index`(`sec_user_id`) USING BTREE,
  INDEX `sec_ou_id_index`(`sec_ou_id`) USING BTREE
) COMMENT = '商品(物料)结构清单' ;

-- ----------------------------
-- Table structure for itm_item_business
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_item_business`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  `bu_treedid` bigint(20) NULL DEFAULT NULL COMMENT '组织树节点ID',
  `item_source` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品识别号',
  `bu_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '组织编号',
  `spu_id` bigint(20) NULL DEFAULT NULL COMMENT 'spuId',
  `spu_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '组织编号',
  `alloc_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '配货类型 [UDC]ITM:ALLOC_TYPE',
  `tax_rate_no` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '税率编号(进项)',
  `tax_rate_no2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '税率编号2(销项)',
  `tax_rate_tariff` decimal(20, 8) NULL DEFAULT NULL COMMENT '关税税率',
  `install_flag` int(11) NULL DEFAULT NULL COMMENT '是否需要安装',
  `return_exchange_flag` int(11) NULL DEFAULT NULL COMMENT '是否可退换货',
  `return_exchange_policy` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '退换货政策 [UDC]ITM:RETURN_EXCHANGE_POLICY',
  `warranty_flag` int(11) NULL DEFAULT NULL COMMENT '是否保修',
  `warranty_period` int(11) NULL DEFAULT NULL COMMENT '保修期时长',
  `warranty_period_unit` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '保修期单位 [UDC]COM:TIME_UNIT',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE,
  INDEX `sec_bu_id_index`(`sec_bu_id`) USING BTREE,
  INDEX `sec_user_id_index`(`sec_user_id`) USING BTREE,
  INDEX `sec_ou_id_index`(`sec_ou_id`) USING BTREE,
  INDEX `codex_spu_code`(`spu_code`) USING BTREE
) COMMENT = '商品经营目录' ;

-- ----------------------------
-- Table structure for itm_item_business_status
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_item_business_status`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `item_id` bigint(20) NULL DEFAULT NULL COMMENT 'skuId',
  `item_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品编码（sku编码）',
  `spu_id` bigint(20) NULL DEFAULT NULL COMMENT 'SPU_ID',
  `spu_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SPU_CODE',
  `item_source` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品来源组织',
  `bu_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品所属公司',
  `item_life_status` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '生命状态',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  PRIMARY KEY (`id`) USING BTREE
) COMMENT = '经营目录状态表' ;

-- ----------------------------
-- Table structure for itm_item_cate
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_item_cate`  (
  `id` bigint(20) NOT NULL,
  `sec_bu_id` bigint(20) NULL DEFAULT NULL,
  `sec_user_id` bigint(20) NULL DEFAULT NULL,
  `sec_ou_id` bigint(20) NULL DEFAULT NULL,
  `pid` bigint(20) NOT NULL,
  `sort_no` int(11) NULL DEFAULT NULL,
  `level` int(11) NULL DEFAULT NULL,
  `id_path` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `code_path` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `item_cate_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '品类编码',
  `item_cate_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '品类名称',
  `item_cate_is_basic` int(5) NULL DEFAULT 0 COMMENT '是否基础类目（0：不是，1：是）',
  `status` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '状态',
  `tenant_id` bigint(20) NULL DEFAULT NULL,
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `create_user_id` bigint(20) NULL DEFAULT NULL,
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `create_time` datetime(6) NULL DEFAULT NULL,
  `modify_user_id` bigint(20) NULL DEFAULT NULL,
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `modify_time` datetime(6) NULL DEFAULT NULL,
  `delete_flag` int(11) NOT NULL,
  `audit_data_version` int(11) NULL DEFAULT NULL,
  `item_cate_desc` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '品类描述',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_cate_pid`(`pid`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE,
  INDEX `sec_bu_id_index`(`sec_bu_id`) USING BTREE,
  INDEX `sec_user_id_index`(`sec_user_id`) USING BTREE,
  INDEX `sec_ou_id_index`(`sec_ou_id`) USING BTREE
) COMMENT = '商品品类' ;

-- ----------------------------
-- Table structure for itm_item_category
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_item_category`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `cate_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '品类编码',
  `cate_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '品类名称',
  `description` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '描述',
  `pid` bigint(20) NULL DEFAULT NULL COMMENT '父类ID',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  PRIMARY KEY (`id`) USING BTREE
) COMMENT = '商品分类' ;

-- ----------------------------
-- Table structure for itm_item_combo
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_item_combo`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  `item_combo_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '组合商品编码',
  `item_combo_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '组合商品名称',
  `item_combo_other_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '组合商品别名',
  `item_combo_type` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '组合商品类型',
  `status` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '状态',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE,
  INDEX `sec_bu_id_index`(`sec_bu_id`) USING BTREE,
  INDEX `sec_user_id_index`(`sec_user_id`) USING BTREE,
  INDEX `sec_ou_id_index`(`sec_ou_id`) USING BTREE
) COMMENT = '组合商品' ;

-- ----------------------------
-- Table structure for itm_item_cust_prop
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_item_cust_prop`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  `item_id` bigint(20) NULL DEFAULT NULL COMMENT '商品ID',
  `cust_prop_key` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '自定义属性Key',
  `cust_prop_value` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '自定义属性Value',
  `status` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '状态',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE,
  INDEX `sec_bu_id_index`(`sec_bu_id`) USING BTREE,
  INDEX `sec_user_id_index`(`sec_user_id`) USING BTREE,
  INDEX `sec_ou_id_index`(`sec_ou_id`) USING BTREE
) COMMENT = '商品自定义属性' ;

-- ----------------------------
-- Table structure for itm_item_cust_prop_applyd
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_item_cust_prop_applyd`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `item_id` bigint(20) NULL DEFAULT NULL COMMENT '商品ID',
  `cust_prop_key` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '自定义属性Key',
  `cust_prop_value` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '自定义属性Value',
  `status` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '状态',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  `doc_no` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '单据编号',
  PRIMARY KEY (`id`) USING BTREE
) COMMENT = '商品自定义属性_履历' ;

-- ----------------------------
-- Table structure for itm_item_prop
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_item_prop`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  `item_id` bigint(20) NULL DEFAULT NULL COMMENT '商品ID',
  `cate_prop_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '属性类型',
  `cate_prop_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '属性名编码',
  `cate_prop_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '属性名名称',
  `prop_value` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '属性名属性值编码',
  `status` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '状态',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE,
  INDEX `sec_bu_id_index`(`sec_bu_id`) USING BTREE,
  INDEX `sec_user_id_index`(`sec_user_id`) USING BTREE,
  INDEX `sec_ou_id_index`(`sec_ou_id`) USING BTREE
) COMMENT = '商品属性' ;

-- ----------------------------
-- Table structure for itm_item_prop_applyd
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_item_prop_applyd`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `item_id` bigint(20) NULL DEFAULT NULL COMMENT '商品ID',
  `cate_prop_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '属性类型',
  `cate_prop_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '属性名编码',
  `cate_prop_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '属性名名称',
  `prop_value` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '属性名属性值编码',
  `status` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '状态',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  `doc_no` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '单据编号',
  PRIMARY KEY (`id`) USING BTREE
) COMMENT = '商品属性_履历' ;

-- ----------------------------
-- Table structure for itm_item_publish
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_item_publish`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  `user_id` bigint(20) NULL DEFAULT NULL COMMENT '发布人ID',
  `publish_time` datetime(0) NULL DEFAULT NULL COMMENT '发布时间',
  `status` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '状态',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE,
  INDEX `sec_bu_id_index`(`sec_bu_id`) USING BTREE,
  INDEX `sec_user_id_index`(`sec_user_id`) USING BTREE,
  INDEX `sec_ou_id_index`(`sec_ou_id`) USING BTREE
) COMMENT = '商品发布管理' ;

-- ----------------------------
-- Table structure for itm_item_qualify
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_item_qualify`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  `ou_id` bigint(20) NULL DEFAULT NULL COMMENT '公司ID',
  `ou_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '公司编号',
  `ou_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '公司名称',
  `bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'BU ID',
  `bu_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'BU编号',
  `bu_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'BU名称',
  `item_id` bigint(20) NULL DEFAULT NULL COMMENT '商品ID',
  `item_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品编号',
  `item_code2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品编号2',
  `item_code3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品编号3',
  `item_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品名称',
  `item_name2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品名称2',
  `item_name3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品名称3',
  `spec` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '规格，比如：食品净含量',
  `spu_id` bigint(20) NULL DEFAULT NULL COMMENT 'SPU_ID',
  `spu_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SPU_CODE',
  `spu_code2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SPU_CODE2',
  `spu_code3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SPU_CODE3',
  `spu_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SPU_NAME',
  `spu_name2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SPU_NAME2',
  `spu_name3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SPU_NAME3',
  `qualify_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '资质类型 [UDC]ITM:QUALIFY_TYPE',
  `qualify_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '资质名称',
  `qualify_no` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '资质编号',
  `qualify_file_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '资质文件名称',
  `qualify_file_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '资质文件编号',
  `valid_from` datetime(6) NULL DEFAULT NULL COMMENT '生效日期',
  `valid_to` datetime(6) NULL DEFAULT NULL COMMENT '失效日期',
  `next_check_date` datetime(6) NULL DEFAULT NULL COMMENT '下次检查日期',
  `longterm_flag` int(11) NULL DEFAULT NULL COMMENT '是否长期有效',
  `qualify_status` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '资质证照状态 [UDC]COM:STATUS_ACTIVEORNO',
  `qualify_status2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '资质证照状态2',
  `qualify_owner` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '证照所有者',
  `related_id1` bigint(20) NULL DEFAULT NULL COMMENT '关联ID1',
  `related_id2` bigint(20) NULL DEFAULT NULL COMMENT '关联ID2',
  `es1` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES1',
  `es2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES2',
  `es3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES3',
  `es4` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES4',
  `es5` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES5',
  `es6` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES6',
  `es7` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES7',
  `es8` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES8',
  `es9` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES9',
  `es10` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES10',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE,
  INDEX `sec_bu_id_index`(`sec_bu_id`) USING BTREE,
  INDEX `sec_user_id_index`(`sec_user_id`) USING BTREE,
  INDEX `sec_ou_id_index`(`sec_ou_id`) USING BTREE
) COMMENT = '商品资质信息' ;

-- ----------------------------
-- Table structure for itm_item_qualify_applyd
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_item_qualify_applyd`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `ou_id` bigint(20) NULL DEFAULT NULL COMMENT '公司ID',
  `ou_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '公司编号',
  `ou_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '公司名称',
  `bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'BU ID',
  `bu_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'BU编号',
  `bu_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'BU名称',
  `item_id` bigint(20) NULL DEFAULT NULL COMMENT '商品ID',
  `item_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品编号',
  `item_code2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品编号2',
  `item_code3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品编号3',
  `item_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品名称',
  `item_name2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品名称2',
  `item_name3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品名称3',
  `spec` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '规格，比如：食品净含量',
  `spu_id` bigint(20) NULL DEFAULT NULL COMMENT 'SPU_ID',
  `spu_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SPU_CODE',
  `spu_code2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SPU_CODE2',
  `spu_code3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SPU_CODE3',
  `spu_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SPU_NAME',
  `spu_name2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SPU_NAME2',
  `spu_name3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SPU_NAME3',
  `qualify_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '资质类型 [UDC]ITM:QUALIFY_TYPE',
  `qualify_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '资质名称',
  `qualify_no` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '资质编号',
  `qualify_file_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '资质文件名称',
  `qualify_file_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '资质文件编号',
  `valid_from` datetime(6) NULL DEFAULT NULL COMMENT '生效日期',
  `valid_to` datetime(6) NULL DEFAULT NULL COMMENT '失效日期',
  `next_check_date` datetime(6) NULL DEFAULT NULL COMMENT '下次检查日期',
  `longterm_flag` int(11) NULL DEFAULT NULL COMMENT '是否长期有效',
  `qualify_status` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '资质证照状态 [UDC]COM:STATUS_ACTIVEORNO',
  `qualify_status2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '资质证照状态2',
  `qualify_owner` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '证照所有者',
  `related_id1` bigint(20) NULL DEFAULT NULL COMMENT '关联ID1',
  `related_id2` bigint(20) NULL DEFAULT NULL COMMENT '关联ID2',
  `es1` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES1',
  `es2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES2',
  `es3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES3',
  `es4` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES4',
  `es5` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES5',
  `es6` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES6',
  `es7` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES7',
  `es8` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES8',
  `es9` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES9',
  `es10` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES10',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  `doc_no` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '单据编号',
  PRIMARY KEY (`id`) USING BTREE
) COMMENT = '商品资质信息_履历' ;

-- ----------------------------
-- Table structure for itm_item_sku_business
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_item_sku_business`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `item_id` bigint(20) NULL DEFAULT NULL COMMENT 'skuId',
  `item_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品编码（sku编码）',
  `spu_id` bigint(20) NULL DEFAULT NULL COMMENT 'SPU_ID',
  `spu_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SPU_CODE',
  `item_source` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品来源组织',
  `bu_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品所属公司',
  `item_life_status` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '生命状态',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `bu_code`(`bu_code`, `item_code`) USING BTREE
) COMMENT = '商品sku经营目录表' ;

-- ----------------------------
-- Table structure for itm_item_status_config
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_item_status_config`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `business_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '业务',
  `business_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '对应场景代码',
  `business_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '场景名称',
  `business_desc` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '场景说明',
  `config_status` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '配置状态',
  `check_basic_status` int(11) NULL DEFAULT NULL COMMENT '是否校验basic商品状态',
  `check_shop_status` int(11) NULL DEFAULT NULL COMMENT '是否校验经营目录商品状态',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  `data_sign` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据标识',
  `busin_excu_sign_status1` int(11) NULL DEFAULT NULL COMMENT '正常',
  `busin_excu_sign_status2` int(11) NULL DEFAULT NULL COMMENT '销售冻结',
  `busin_excu_sign_status3` int(11) NULL DEFAULT NULL COMMENT '采购冻结',
  `busin_excu_sign_status4` int(11) NULL DEFAULT NULL COMMENT '业务执行标识4',
  `busin_excu_sign_status5` int(11) NULL DEFAULT NULL COMMENT '业务执行标识5',
  `busin_excu_sign_status6` int(11) NULL DEFAULT NULL COMMENT '业务执行标识6',
  `busin_excu_sign_status7` int(11) NULL DEFAULT NULL COMMENT '业务执行标识7',
  `busin_excu_sign_status8` int(11) NULL DEFAULT NULL COMMENT '业务执行标识8',
  `busin_excu_sign_status9` int(11) NULL DEFAULT NULL COMMENT '业务执行标识9',
  `busin_excu_sign_status10` int(11) NULL DEFAULT NULL COMMENT '业务执行标识4910',
  PRIMARY KEY (`id`) USING BTREE
) COMMENT = '商品状态配置表' ;

-- ----------------------------
-- Table structure for itm_item_tag
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_item_tag`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  `item_id` bigint(20) NULL DEFAULT NULL COMMENT '商品ID',
  `upper_tag_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '上级标签编码',
  `upper_tag_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '上级标签名称',
  `tag_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '标签编码',
  `tag_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '标签名称',
  `status` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '状态',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE,
  INDEX `sec_bu_id_index`(`sec_bu_id`) USING BTREE,
  INDEX `sec_user_id_index`(`sec_user_id`) USING BTREE,
  INDEX `sec_ou_id_index`(`sec_ou_id`) USING BTREE
) COMMENT = '商品标签' ;

-- ----------------------------
-- Table structure for itm_item_tag_applyd
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_item_tag_applyd`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `item_id` bigint(20) NULL DEFAULT NULL COMMENT '商品ID',
  `upper_tag_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '上级标签编码',
  `upper_tag_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '上级标签名称',
  `tag_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '标签编码',
  `tag_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '标签名称',
  `status` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '状态',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  `doc_no` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '单据编号',
  PRIMARY KEY (`id`) USING BTREE
) COMMENT = '商品标签_履历' ;

-- ----------------------------
-- Table structure for itm_item_temp
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_item_temp`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
  `ou_id` bigint(20) NULL DEFAULT NULL COMMENT '公司ID',
  `ou_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '公司编号',
  `ou_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '公司名称',
  `bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'BU ID',
  `bu_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'BU编号',
  `bu_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'BU名称',
  `item_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品编号',
  `item_code2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品编号2',
  `item_code3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品编号3',
  `item_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品名称',
  `item_name2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品名称2',
  `item_name3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品名称3',
  `item_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品类型 [UDC]ITM:ITEM_TYPE',
  `item_type2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品类型2 [UDC]ITM:ITEM_TYPE2',
  `item_type3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品类型3',
  `item_type4` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品类型4',
  `item_type5` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品类型5',
  `item_status` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品状态 [UDC]ITM:ITEM_STATUS',
  `item_status2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品状态2',
  `item_status3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品状态3',
  `spec` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '规格，比如：食品净含量',
  `spu_id` bigint(20) NULL DEFAULT NULL COMMENT 'SPU_ID',
  `spu_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SPU_CODE',
  `spu_code2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SPU_CODE2',
  `spu_code3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SPU_CODE3',
  `spu_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SPU_NAME',
  `spu_name2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SPU_NAME2',
  `spu_name3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SPU_NAME3',
  `item_attr` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品规格',
  `item_attr2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品规格2',
  `item_attr3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品规格3',
  `item_attr4` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品规格4',
  `item_attr5` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品规格5',
  `item_cat_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品品类编号',
  `item_cat_code2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品品类编号2',
  `item_cat_code3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品品类编号3',
  `brand` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '品牌',
  `brand2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '品牌2',
  `salepurc_flag` int(11) NULL DEFAULT NULL COMMENT '是否允许自采',
  `sn_flag` int(11) NULL DEFAULT NULL COMMENT '是否启用序列号',
  `lot_flag` int(11) NULL DEFAULT NULL COMMENT '是否启用批次号',
  `guarantee_flag` int(11) NULL DEFAULT NULL COMMENT '效期管理标识',
  `fin_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '财务分类 [UDC]ITM:FIN_TYPE',
  `cost_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '成本计价方法 [UDC]ITM:COST_TYPE',
  `alloc_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '配货类型 [UDC]ITM:ALLOC_TYPE',
  `deliver_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '配送类型 [UDC]ITM:DELIVER_TYPE',
  `install_flag` int(11) NULL DEFAULT NULL COMMENT '是否需要安装',
  `return_exchange_flag` int(11) NULL DEFAULT NULL COMMENT '是否可退换货',
  `return_exchange_policy` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '退换货政策 [UDC]ITM:RETURN_EXCHANGE_POLICY',
  `warranty_flag` int(11) NULL DEFAULT NULL COMMENT '是否保修',
  `warranty_period` int(11) NULL DEFAULT NULL COMMENT '保修期时长',
  `warranty_period_unit` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '保修期单位 [UDC]COM:TIME_UNIT',
  `trans_condition` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '运输条件',
  `store_condition` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '存储条件',
  `package_spec` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '包装规格',
  `guarantee_period` int(11) NULL DEFAULT NULL COMMENT '保质期时长',
  `guarantee_period_unit` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '保质期单位 [UDC]COM:TIME_UNIT',
  `guarantee_days` int(11) NULL DEFAULT NULL COMMENT '保质期天数',
  `tax_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '税码(进项)',
  `tax_rate` decimal(8, 0) NULL DEFAULT NULL COMMENT '税率(进项)',
  `tax_rate_no` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '税率编号(进项)',
  `tax_code2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '税码2(销项)',
  `tax_rate2` decimal(8, 0) NULL DEFAULT NULL COMMENT '税率2(销项)',
  `tax_rate_no2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '税率编号2(销项)',
  `tax_rate_tariff` decimal(8, 0) NULL DEFAULT NULL COMMENT '关税税率',
  `supp_id` bigint(20) NULL DEFAULT NULL COMMENT '供应商ID',
  `supp_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '供应商编号',
  `supp_abbr` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '供应商简称',
  `supp_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '供应商名称',
  `supp_item_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '供应商物料编码',
  `bar_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '条码',
  `bar_code2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '条码',
  `uom` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '主计量单位 [UDC]COM:UOM',
  `uom2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '主计量单位2 [UDC]COM:UOM',
  `uom3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '主计量单位3 [UDC]COM:UOM',
  `uom4` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '主计量单位4 [UDC]COM:UOM',
  `uom5` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '主计量单位5 [UDC]COM:UOM',
  `sale_uom` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '默认销售单位 [UDC]COM:UOM',
  `purc_uom` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '默认采购单位 [UDC]COM:UOM',
  `ship_uom` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '发运计量单位 [UDC]COM:UOM',
  `order_uom` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '要货计量单位 [UDC]COM:UOM',
  `pricing_uom` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '定价计量单位 [UDC]COM:UOM',
  `store_uom` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '库存计量单位 [UDC]COM:UOM',
  `gross_weight` decimal(4, 0) NULL DEFAULT NULL COMMENT '毛重',
  `net_weight` decimal(4, 0) NULL DEFAULT NULL COMMENT '净重',
  `weight_unit` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '重量单位 [UDC]COM:WEIGHT_UNIT',
  `weight_item_uom` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '重量对应的品项单位 [UDC]COM:UOM',
  `volume` decimal(4, 0) NULL DEFAULT NULL COMMENT '体积',
  `volume_unit` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '体积单位 [UDC]COM:VOLUME_UNIT',
  `length` decimal(4, 0) NULL DEFAULT NULL COMMENT '长',
  `width` decimal(4, 0) NULL DEFAULT NULL COMMENT '宽',
  `height` decimal(4, 0) NULL DEFAULT NULL COMMENT '高',
  `length_unit` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '长度单位 [UDC]COM:LENGTH_UNIT',
  `moq` decimal(4, 0) NULL DEFAULT NULL COMMENT '最小起定量',
  `safe_qty` decimal(4, 0) NULL DEFAULT NULL COMMENT '安全库存',
  `max_order_qty` decimal(4, 0) NULL DEFAULT NULL COMMENT '最大要货量',
  `tags` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '标签',
  `outer_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '外部编号',
  `outer_code2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '外部编号2',
  `cat` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码 [UDC]ITM:ITM_CAT',
  `cat2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码 [UDC]ITM:ITM_CAT2',
  `cat3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码 [UDC]ITM:ITM_CAT3',
  `cat4` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码 [UDC]ITM:ITM_CAT4',
  `cat5` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码 [UDC]ITM:ITM_CAT5',
  `cat6` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码 [UDC]ITM:ITM_CAT6',
  `cat7` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码 [UDC]ITM:ITM_CAT7',
  `cat8` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码 [UDC]ITM:ITM_CAT8',
  `cat9` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码 [UDC]ITM:ITM_CAT9',
  `cat10` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码 [UDC]ITM:ITM_CAT10',
  `es1` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES1',
  `es2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES2',
  `es3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES3',
  `es4` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES4',
  `es5` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES5',
  `es6` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES6',
  `es7` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES7',
  `es8` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES8',
  `es9` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES9',
  `es10` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES10',
  `en1` decimal(8, 0) NULL DEFAULT NULL COMMENT 'EN1',
  `en2` decimal(8, 0) NULL DEFAULT NULL COMMENT 'EN2',
  `en3` decimal(8, 0) NULL DEFAULT NULL COMMENT 'EN3',
  `en4` decimal(8, 0) NULL DEFAULT NULL COMMENT 'EN4',
  `en5` decimal(8, 0) NULL DEFAULT NULL COMMENT 'EN5',
  `ed1` datetime(6) NULL DEFAULT NULL COMMENT 'ED1',
  `ed2` datetime(6) NULL DEFAULT NULL COMMENT 'ED2',
  `ed3` datetime(6) NULL DEFAULT NULL COMMENT 'ED3',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE
)  COMMENT = '商品temp' ;

-- ----------------------------
-- Table structure for itm_item_tmp
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_item_tmp`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
  `tax_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '税收分类码 [UDC]ITM:TAX_TYPE',
  `package_method` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '包装方式 [UDC]ITM:PACKAGE_METHOD',
  `ou_id` bigint(20) NULL DEFAULT NULL COMMENT '公司ID',
  `bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'BUID',
  `item_code` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '品项编号',
  `item_code2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '第二编号',
  `item_code3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '第三编号',
  `item_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '品项名称',
  `item_name2` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '第二名称',
  `item_name3` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '第三名称',
  `item_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '品项类型 [UDC]ITM:ITEM_TYPE',
  `item_type2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '品项类型2 [UDC]ITM:ITEM_TYPE2',
  `item_type3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '品项类型3 [UDC]ITM:ITEM_TYPE3',
  `item_type4` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '品项类型4',
  `item_type5` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '品项类型5',
  `item_group` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '品项组 [UDC]ITM:ITEM_GROUP',
  `item_abbr` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '品项简称',
  `item_title` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '品项标题 简短介绍',
  `item_desc` varchar(2000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '品项描述 文描，可含有格式，包含导航段落信息',
  `sub_title` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '副标题 如京东有',
  `mem_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '助记码',
  `bar_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '条码',
  `bar_code2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '条码2',
  `pinyin` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '拼音',
  `pinyin_sh` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '拼音简称',
  `promotion_info` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '促销信息',
  `keywords` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '关键词',
  `marks` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '标记 如热销、推荐、正品、新品。可多选',
  `item_status` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '品项状态',
  `item_status2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '品项状态2',
  `item_status3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '品项状态3',
  `listing_status` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '上架状态',
  `c1_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '大类编号 使用COM_C1表',
  `c2_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '中类编号 使用COM_C2表',
  `c3_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '小类编号',
  `uom` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '主计量单位',
  `uom2` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '计量单位2',
  `uom3` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '计量单位3',
  `uom4` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '计量单位4',
  `uom5` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '计量单位5',
  `sale_uom` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '默认销售单位',
  `purc_uom` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '默认采购单位',
  `ship_uom` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '发运计量单位',
  `order_uom` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '要货计量单位',
  `pricing_uom` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '定价计量单位',
  `gross_weight` decimal(20, 4) NULL DEFAULT NULL COMMENT '毛重',
  `net_weight` decimal(20, 4) NULL DEFAULT NULL COMMENT '净重',
  `weight_uom` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '重量单位 克还是吨',
  `weight_itemuom` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '重量对应的品项单位 支还是千支',
  `gross_weight2` decimal(20, 4) NULL DEFAULT NULL COMMENT '毛重2',
  `net_weight2` decimal(20, 4) NULL DEFAULT NULL COMMENT '净重2',
  `weight_uom2` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '重量2单位 克还是吨',
  `weight_itemuom2` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '重量2对应的品项单位 箱或包等包装单位',
  `volume` decimal(20, 4) NULL DEFAULT NULL COMMENT '体积',
  `volume_uom` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '体积单位',
  `moq` decimal(20, 4) NULL DEFAULT NULL COMMENT '最小起订量',
  `safe_qty` decimal(20, 4) NULL DEFAULT NULL COMMENT '安全库存',
  `max_qty` decimal(20, 4) NULL DEFAULT NULL COMMENT '最大库存量',
  `max_order_qty` decimal(20, 4) NULL DEFAULT NULL COMMENT '最大要货量',
  `package_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '存储类型',
  `package_qty` decimal(20, 4) NULL DEFAULT NULL COMMENT '整包装数量',
  `batch_qty` decimal(20, 4) NULL DEFAULT NULL COMMENT '批量',
  `order_tolerance` decimal(12, 8) NULL DEFAULT NULL COMMENT '要货容差率',
  `sale_price` decimal(20, 4) NULL DEFAULT NULL COMMENT '默认售价',
  `sale_price_group` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '销售价格组',
  `purc_price` decimal(20, 4) NULL DEFAULT NULL COMMENT '默认采购价',
  `purc_price_group` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '采购价格组',
  `item_price` decimal(20, 4) NULL DEFAULT NULL COMMENT '价格',
  `price_period` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '调价周期',
  `stall_id` bigint(20) NULL DEFAULT NULL COMMENT '档口ID',
  `stall_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '档口编号',
  `package_spec` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '包装规格',
  `spec` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '规格',
  `material` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '材质',
  `grade` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '等级',
  `standard` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '标准',
  `surface` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '表面处理',
  `origin` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '产地',
  `stamp` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '印记',
  `item_length` decimal(20, 2) NULL DEFAULT NULL COMMENT '长度',
  `item_width` decimal(20, 2) NULL DEFAULT NULL COMMENT '宽度',
  `item_height` decimal(20, 2) NULL DEFAULT NULL COMMENT '高度',
  `dimension_uom` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '尺寸单位',
  `dimension` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '直径',
  `strength` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '强度',
  `teeth` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '牙别',
  `tax_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '税码 进项VAT',
  `tax_rate_index` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '税率索引 进项',
  `tax_rate_no` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '税率编号 进项VAT',
  `tax_rate` decimal(18, 8) NULL DEFAULT NULL COMMENT '税率 进项VAT',
  `tax_code_out` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '税码 销项VAT',
  `tax_rate_indexout` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '税率索引 销项',
  `tax_rate_noout` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '税率编号 销项VAT',
  `tax_rate_out` decimal(18, 8) NULL DEFAULT NULL COMMENT '税率 销项VAT',
  `tax_rate_tariff` decimal(18, 8) NULL DEFAULT NULL COMMENT '关税税率',
  `purchaser_id` bigint(20) NULL DEFAULT NULL COMMENT '采购员ID',
  `salesman_id` bigint(20) NULL DEFAULT NULL COMMENT '销售员ID',
  `purchaser_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '采购员姓名',
  `salesman_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '销售员姓名',
  `supp_id` bigint(20) NULL DEFAULT NULL COMMENT '供应商ID',
  `supp_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '供应商名称',
  `brand` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '品牌',
  `brand2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '品牌2',
  `agency` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '代理商',
  `req_dept_id` bigint(20) NULL DEFAULT NULL COMMENT '要求部门ID',
  `req_reason` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '要求原因',
  `usage_desc` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '用途描述',
  `approve_date` datetime(0) NULL DEFAULT NULL COMMENT '转正日期',
  `fin_gl_type` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '财务总账类别 [UDC]ITM:FIN_GL_TYPE',
  `cost_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '成本计价方式 FIFO/加权平均',
  `cost_leve` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '成本级 [UDC]ITM:COST_LEVEL',
  `purchase_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '采购类型 按计划采购/日常请购',
  `purchase_type2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '采购类型2 集采/地产',
  `alloc_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '配货类型 总部强配/门店要货',
  `deliver_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '配送类型 总部配送/供应商配送',
  `order_period` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '订货周期',
  `abc_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '库存ABC类型',
  `store_out_method` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '库存出库方式 FIFO/LIFO/批内FIFO/批内FILO',
  `store_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '库存管理类型 [UDC]ITM:STORE_TYPE',
  `store_mode` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '存储方式 [UDC]ITM:STORE_MODE',
  `store_expire_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '保质期管理类型',
  `expire_duration` bigint(20) NULL DEFAULT NULL COMMENT '保质期时长',
  `expire_duration_uom` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '保质期单位',
  `store_condition` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '存储条件',
  `temp_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '温层',
  `shipment_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '发运类型',
  `rebate_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '供应商回扣类型',
  `plan_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '计划类型',
  `take_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '盘点类型 30天/60天',
  `wh_prop` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '仓库属性',
  `semi_store` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '半成品存储仓位',
  `rep_item_rate` decimal(20, 4) NULL DEFAULT NULL COMMENT '转换率',
  `lot_flag` tinyint(1) NULL DEFAULT NULL COMMENT '默认启用批次',
  `loc_flag` tinyint(1) NULL DEFAULT NULL COMMENT '默认启用货位',
  `sn_flag` tinyint(1) NULL DEFAULT NULL COMMENT '默认启用序列号',
  `install_flag` tinyint(1) NULL DEFAULT NULL COMMENT '是否安装',
  `return_exchange_flag` tinyint(1) NULL DEFAULT NULL COMMENT '退换承诺',
  `warranty_flag` tinyint(1) NULL DEFAULT NULL COMMENT '是否保修',
  `warranty_duration` bigint(20) NULL DEFAULT NULL COMMENT '保修时长',
  `warranty_duration_uom` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '保修时长单位',
  `menu_country` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '原产国',
  `manu_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '制造类型 成品/半成品/原料/物料',
  `manuer_id` bigint(20) NULL DEFAULT NULL COMMENT '制造商ID',
  `manuer_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '制造商名称',
  `supp_item_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '供应商物料编码',
  `std_cost` decimal(20, 4) NULL DEFAULT NULL COMMENT '标准成本',
  `std_lab_cost` decimal(20, 4) NULL DEFAULT NULL COMMENT '标准人工',
  `std_prod_cost` decimal(20, 4) NULL DEFAULT NULL COMMENT '标准制费',
  `replace_prop` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '替代属性 1：标准原料；2：替代原料',
  `replace_item_id` bigint(20) NULL DEFAULT NULL COMMENT '替代原料ID',
  `other_type1` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '其它类型1',
  `other_type2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '其它类型2',
  `other_type3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '其它类型3',
  `other_type4` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '其它类型4',
  `other_type5` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '其它类型5',
  `outer_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '外部编码',
  `intf_status` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '接口状态',
  `intf_time` datetime(0) NULL DEFAULT NULL COMMENT '接口处理时间',
  `tags` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '标签',
  `es1` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES1',
  `es2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES2',
  `es3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES3',
  `es4` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES4',
  `es5` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES5',
  `es6` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES6',
  `es7` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES7',
  `es8` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES8',
  `es9` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES9',
  `es10` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES10',
  `es11` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES11',
  `es12` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES12',
  `es13` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES13',
  `es14` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES14',
  `es15` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES15',
  `es16` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES16',
  `es17` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES17',
  `es18` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES18',
  `es19` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES19',
  `es20` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES20',
  `en1` decimal(20, 2) NULL DEFAULT NULL COMMENT 'EN1',
  `en2` decimal(20, 2) NULL DEFAULT NULL COMMENT 'EN2',
  `en3` decimal(20, 2) NULL DEFAULT NULL COMMENT 'EN3',
  `en4` decimal(20, 2) NULL DEFAULT NULL COMMENT 'EN4',
  `en5` decimal(20, 2) NULL DEFAULT NULL COMMENT 'EN5',
  `ed1` datetime(0) NULL DEFAULT NULL COMMENT 'ED1',
  `ed2` datetime(0) NULL DEFAULT NULL COMMENT 'ED2',
  `ed3` datetime(0) NULL DEFAULT NULL COMMENT 'ED3',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NULL DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  `guarantee_flag` tinyint(1) NULL DEFAULT NULL COMMENT '效期管理标识',
  `guarantee_period` bigint(20) NULL DEFAULT NULL COMMENT '保质期时长',
  `guarantee_period_unit` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '保质期单位',
  `trans_condition` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '运输条件',
  `warranty_period` bigint(20) NULL DEFAULT NULL COMMENT '保修时长',
  `warranty_period_unit` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '保修时长单位',
  `item_len` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '长度',
  `store_expire_days` bigint(20) NULL DEFAULT NULL COMMENT '保质期天数',
  `item_cate_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '品类编号',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE
)  COMMENT = '商品' ;

-- ----------------------------
-- Table structure for itm_item_yd
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_item_yd`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
  `ou_id` bigint(20) NULL DEFAULT NULL COMMENT '公司ID',
  `ou_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '公司编号',
  `ou_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '公司名称',
  `bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'BU ID',
  `bu_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'BU编号',
  `bu_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'BU名称',
  `item_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品编号',
  `item_code2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品编号2',
  `item_code3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品编号3',
  `item_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品名称',
  `item_name2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品名称2',
  `item_name3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品名称3',
  `item_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品类型 [UDC]ITM:ITEM_TYPE',
  `item_type2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品类型2 [UDC]ITM:ITEM_TYPE2',
  `item_type3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品类型3',
  `item_type4` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品类型4',
  `item_type5` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品类型5',
  `item_status` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品状态 [UDC]ITM:ITEM_STATUS',
  `item_status2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品状态2',
  `item_status3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品状态3',
  `spec` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '规格，比如：食品净含量',
  `spu_id` bigint(20) NULL DEFAULT NULL COMMENT 'SPU_ID',
  `spu_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SPU_CODE',
  `spu_code2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SPU_CODE2',
  `spu_code3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SPU_CODE3',
  `spu_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SPU_NAME',
  `spu_name2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SPU_NAME2',
  `spu_name3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SPU_NAME3',
  `item_attr` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品规格',
  `item_attr2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品规格2',
  `item_attr3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品规格3',
  `item_attr4` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品规格4',
  `item_attr5` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品规格5',
  `item_cat_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品品类编号',
  `item_cat_code2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品品类编号2',
  `item_cat_code3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品品类编号3',
  `brand` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '品牌',
  `brand2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '品牌2',
  `salepurc_flag` int(11) NULL DEFAULT NULL COMMENT '是否允许自采',
  `sn_flag` int(11) NULL DEFAULT NULL COMMENT '是否启用序列号',
  `lot_flag` int(11) NULL DEFAULT NULL COMMENT '是否启用批次号',
  `guarantee_flag` int(11) NULL DEFAULT NULL COMMENT '效期管理标识',
  `fin_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '财务分类 [UDC]ITM:FIN_TYPE',
  `cost_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '成本计价方法 [UDC]ITM:COST_TYPE',
  `alloc_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '配货类型 [UDC]ITM:ALLOC_TYPE',
  `deliver_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '配送类型 [UDC]ITM:DELIVER_TYPE',
  `install_flag` int(11) NULL DEFAULT NULL COMMENT '是否需要安装',
  `return_exchange_flag` int(11) NULL DEFAULT NULL COMMENT '是否可退换货',
  `return_exchange_policy` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '退换货政策 [UDC]ITM:RETURN_EXCHANGE_POLICY',
  `warranty_flag` int(11) NULL DEFAULT NULL COMMENT '是否保修',
  `warranty_period` bigint(20) NULL DEFAULT NULL COMMENT '保修期时长',
  `warranty_period_unit` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '保修期单位 [UDC]COM:TIME_UNIT',
  `trans_condition` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '运输条件',
  `store_condition` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '存储条件',
  `package_spec` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '包装规格',
  `guarantee_period` bigint(20) NULL DEFAULT NULL COMMENT '保质期时长',
  `origin` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '产地',
  `guarantee_period_unit` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '保质期单位 [UDC]COM:TIME_UNIT',
  `tax_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '税码(进项)',
  `tax_rate` double NULL DEFAULT NULL COMMENT '税率(进项)',
  `tax_rate_no` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '税率编号(进项)',
  `tax_code2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '税码2(销项)',
  `tax_rate2` double NULL DEFAULT NULL COMMENT '税率2(销项)',
  `tax_rate_no2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '税率编号2(销项)',
  `tax_rate_tariff` double NULL DEFAULT NULL COMMENT '关税税率',
  `supp_id` bigint(20) NULL DEFAULT NULL COMMENT '供应商ID',
  `supp_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '供应商编号',
  `supp_abbr` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '供应商简称',
  `supp_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '供应商名称',
  `supp_item_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '供应商物料编码',
  `bar_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '条码',
  `bar_code2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '条码',
  `uom` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '主计量单位 [UDC]COM:UOM',
  `uom2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '主计量单位2 [UDC]COM:UOM',
  `uom3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '主计量单位3 [UDC]COM:UOM',
  `uom4` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '主计量单位4 [UDC]COM:UOM',
  `uom5` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '主计量单位5 [UDC]COM:UOM',
  `sale_uom` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '默认销售单位 [UDC]COM:UOM',
  `purc_uom` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '默认采购单位 [UDC]COM:UOM',
  `ship_uom` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '发运计量单位 [UDC]COM:UOM',
  `order_uom` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '要货计量单位 [UDC]COM:UOM',
  `pricing_uom` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '定价计量单位 [UDC]COM:UOM',
  `store_uom` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '库存计量单位 [UDC]COM:UOM',
  `gross_weight` double NULL DEFAULT NULL COMMENT '毛重',
  `net_weight` double NULL DEFAULT NULL COMMENT '净重',
  `weight_unit` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '重量单位 [UDC]COM:WEIGHT_UNIT',
  `weight_item_uom` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '重量对应的品项单位 [UDC]COM:UOM',
  `volume` double NULL DEFAULT NULL COMMENT '体积',
  `volume_unit` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '体积单位 [UDC]COM:VOLUME_UNIT',
  `length` double NULL DEFAULT NULL COMMENT '长',
  `width` double NULL DEFAULT NULL COMMENT '宽',
  `height` double NULL DEFAULT NULL COMMENT '高',
  `length_unit` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '长度单位 [UDC]COM:LENGTH_UNIT',
  `moq` double NULL DEFAULT NULL COMMENT '最小起定量',
  `safe_qty` double NULL DEFAULT NULL COMMENT '安全库存',
  `max_order_qty` double NULL DEFAULT NULL COMMENT '最大要货量',
  `tags` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '标签',
  `outer_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '外部编号',
  `outer_code2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '外部编号2',
  `cat` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码 [UDC]ITM:ITM_CAT',
  `cat2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码 [UDC]ITM:ITM_CAT2',
  `cat3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码 [UDC]ITM:ITM_CAT3',
  `cat4` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码 [UDC]ITM:ITM_CAT4',
  `cat5` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码 [UDC]ITM:ITM_CAT5',
  `cat6` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码 [UDC]ITM:ITM_CAT6',
  `cat7` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码 [UDC]ITM:ITM_CAT7',
  `cat8` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码 [UDC]ITM:ITM_CAT8',
  `cat9` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码 [UDC]ITM:ITM_CAT9',
  `cat10` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码 [UDC]ITM:ITM_CAT10',
  `es1` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES1',
  `es2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES2',
  `es3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES3',
  `es4` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES4',
  `es5` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES5',
  `es6` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES6',
  `es7` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES7',
  `es8` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES8',
  `es9` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES9',
  `es10` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES10',
  `en1` decimal(8, 0) NULL DEFAULT NULL COMMENT 'EN1',
  `en2` decimal(8, 0) NULL DEFAULT NULL COMMENT 'EN2',
  `en3` decimal(8, 0) NULL DEFAULT NULL COMMENT 'EN3',
  `en4` decimal(8, 0) NULL DEFAULT NULL COMMENT 'EN4',
  `en5` decimal(8, 0) NULL DEFAULT NULL COMMENT 'EN5',
  `ed1` datetime(6) NULL DEFAULT NULL COMMENT 'ED1',
  `ed2` datetime(6) NULL DEFAULT NULL COMMENT 'ED2',
  `ed3` datetime(6) NULL DEFAULT NULL COMMENT 'ED3',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NULL DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE
)  ;

-- ----------------------------
-- Table structure for itm_itemuom_conv
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_itemuom_conv`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  `item_id` bigint(20) NULL DEFAULT NULL COMMENT '商品id',
  `from_uom` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '从单位',
  `to_uom` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '到单位',
  `ratio` decimal(20, 8) NULL DEFAULT NULL COMMENT '转换系数',
  `revert_ratio` decimal(20, 8) NULL DEFAULT NULL COMMENT '反向系数',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  `line_no` bigint(20) NULL DEFAULT NULL COMMENT '行号',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE,
  INDEX `sec_bu_id_index`(`sec_bu_id`) USING BTREE,
  INDEX `sec_user_id_index`(`sec_user_id`) USING BTREE,
  INDEX `sec_ou_id_index`(`sec_ou_id`) USING BTREE
) COMMENT = '商品计量单位转换' ;

-- ----------------------------
-- Table structure for itm_itemuom_conv_applyd
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_itemuom_conv_applyd`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `item_id` bigint(20) NULL DEFAULT NULL COMMENT '商品id',
  `from_uom` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '从单位',
  `to_uom` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '到单位',
  `ratio` decimal(20, 8) NULL DEFAULT NULL COMMENT '转换系数',
  `revert_ratio` decimal(20, 8) NULL DEFAULT NULL COMMENT '反向系数',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  `doc_no` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '单据编号',
  `line_no` bigint(20) NULL DEFAULT NULL COMMENT '行号',
  PRIMARY KEY (`id`) USING BTREE
) COMMENT = '商品计量单位转换_履历' ;

-- ----------------------------
-- Table structure for itm_life_status_scheduling
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_life_status_scheduling`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `ou_id` bigint(20) NULL DEFAULT NULL COMMENT '创建人所属公司id',
  `ou_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人所属公司编码',
  `ou_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人所属公司名称',
  `bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'BU ID',
  `bu_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'BU编号',
  `bu_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'BU名称',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  `life_status_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '生命状态编码',
  `item_source` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品来源',
  `item_id` bigint(20) NULL DEFAULT NULL COMMENT '商品ID',
  `item_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品编号',
  `item_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '商品名称',
  `branch_plant` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '范围',
  `global_or_not` int(11) NULL DEFAULT NULL COMMENT '是否全局',
  `item_life_status` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '生命状态',
  `valid_from` datetime(6) NULL DEFAULT NULL COMMENT '生效时间',
  `valid_to` datetime(6) NULL DEFAULT NULL COMMENT '失效时间',
  `status` int(11) NULL DEFAULT NULL COMMENT '活动状态',
  PRIMARY KEY (`id`) USING BTREE
) COMMENT = '商品生命状态日程表' ;

-- ----------------------------
-- Table structure for itm_prop
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_prop`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  `cate_prop_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '属性名编码',
  `cate_prop_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '属性名名称',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `ux_prop_code`(`cate_prop_code`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE,
  INDEX `sec_bu_id_index`(`sec_bu_id`) USING BTREE,
  INDEX `sec_user_id_index`(`sec_user_id`) USING BTREE,
  INDEX `sec_ou_id_index`(`sec_ou_id`) USING BTREE
) COMMENT = '属性表' ;

-- ----------------------------
-- Table structure for itm_prop_value
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_prop_value`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
  `cate_prop_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '属性名编码',
  `prop_value_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '属性值编码',
  `prop_value_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '属性值名称',
  `prop_value_rank` int(11) NULL DEFAULT NULL COMMENT '属性值排序',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NULL DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE
)  COMMENT = '品类属性value表' ;

-- ----------------------------
-- Table structure for itm_store_item_list
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_store_item_list`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `store_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `pos_type_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `item_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `bus_type` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `appr_status` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  PRIMARY KEY (`id`) USING BTREE
) COMMENT = '门店可售清单表' ;

-- ----------------------------
-- Table structure for itm_tag
-- ----------------------------
CREATE TABLE IF NOT EXISTS `itm_tag`  (
  `id` bigint(20) NOT NULL,
  `sec_bu_id` bigint(20) NULL DEFAULT NULL,
  `sec_user_id` bigint(20) NULL DEFAULT NULL,
  `sec_ou_id` bigint(20) NULL DEFAULT NULL,
  `pid` bigint(20) NOT NULL,
  `sort_no` int(11) NULL DEFAULT NULL,
  `level` int(11) NULL DEFAULT NULL,
  `id_path` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `code_path` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `tag_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '标签编码',
  `tag_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '标签名称',
  `tag_type` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '标签类型',
  `tag_desc` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '标签描述',
  `status` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '状态',
  `tenant_id` bigint(20) NULL DEFAULT NULL,
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `create_user_id` bigint(20) NULL DEFAULT NULL,
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `create_time` datetime(6) NULL DEFAULT NULL,
  `modify_user_id` bigint(20) NULL DEFAULT NULL,
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `modify_time` datetime(6) NULL DEFAULT NULL,
  `delete_flag` int(11) NOT NULL,
  `audit_data_version` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_tag_pid`(`pid`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE,
  INDEX `sec_bu_id_index`(`sec_bu_id`) USING BTREE,
  INDEX `sec_user_id_index`(`sec_user_id`) USING BTREE,
  INDEX `sec_ou_id_index`(`sec_ou_id`) USING BTREE
) COMMENT = '标签' ;

-- ----------------------------
-- Table structure for mdm_sync_emp
-- ----------------------------
CREATE TABLE IF NOT EXISTS `mdm_sync_emp`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  `lstupdt_date` datetime(0) NULL DEFAULT NULL COMMENT 'LSTUPDT_DATE',
  `emp_id` bigint(20) NULL DEFAULT NULL COMMENT 'EMP_ID',
  `cg_join_chngas_dt` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'CG_JOIN_CHNGAS_DT',
  `birthdate` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'BIRTHDATE',
  `gender` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'GENDER',
  `start_dt_chn` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'START_DT_CHN',
  `cg_join_company_dt` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'CG_JOIN_COMPANY_DT',
  `emp_uuid` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'EMP_UUID',
  `e_mail` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'E_MAIL',
  `hire_dt` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'HIRE_DT',
  `cg_ter_dt` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'CG_TER_DT',
  `ident_type` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'IDENT_TYPE',
  `emp_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'EMP_NAME',
  `ethnic_grp_cd` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ETHNIC_GRP_CD',
  `lstupdt_date_str` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'LSTUPDT_DATE_STR',
  `mar_status` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'MAR_STATUS',
  `cg_fertly_status` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'CG_FERTLY_STATUS',
  `cg_adj_anle_mons` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'CG_ADJ_ANLE_MONS',
  `mobile` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'MOBILE',
  `last_upddttm` datetime(0) NULL DEFAULT NULL COMMENT 'LAST_UPDDTTM',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT 'UPDATE_TIME',
  `emp_no` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'EMP_NO',
  `hr_status` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'HR_STATUS',
  `attribute5` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ATTRIBUTE5',
  `attribute4` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ATTRIBUTE4',
  `reg_region` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'REG_REGION',
  `attribute1` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ATTRIBUTE1',
  `cg_forw_dt` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'CG_FORW_DT',
  `attribute3` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ATTRIBUTE3',
  `middle_name` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'MIDDLE_NAME',
  `attribute2` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ATTRIBUTE2',
  `ident_id` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'IDENT_ID',
  `status` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'STATUS',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL DEFAULT 0 COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  `dept_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'DEPT_ID',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `sec_bu_id_index`(`sec_bu_id`) USING BTREE,
  INDEX `sec_user_id_index`(`sec_user_id`) USING BTREE,
  INDEX `sec_ou_id_index`(`sec_ou_id`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE
) COMMENT = '同步MDM人员' ;

-- ----------------------------
-- Table structure for mdm_sync_org_emp
-- ----------------------------
CREATE TABLE IF NOT EXISTS `mdm_sync_org_emp`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  `cux_company_area` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'CUX_COMPANY_AREA',
  `deptid_descr` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'DEPTID_DESCR',
  `effdt` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'EFFDT',
  `setid_jobcode` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SETID_JOBCODE',
  `empl_id` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'EMPL_ID',
  `jobcode_descr` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'JOBCODE_DESCR',
  `cg_jobcode_descr` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'CG_JOBCODE_DESCR',
  `setid_dept` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SETID_DEPT',
  `gp_company_descr` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'GP_COMPANY_DESCR',
  `company` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'COMPANY',
  `cg_corp_company` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'CG_CORP_COMPANY',
  `dept_id` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'DEPT_ID',
  `cux_cost_center` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'CUX_COST_CENTER',
  `hr_status` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'HR_STATUS',
  `cg_deptid_descr0` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'CG_DEPTID_DESCR0',
  `empl_class` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'EMPL_CLASS',
  `attribute1` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ATTRIBUTE1',
  `attribute2` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ATTRIBUTE2',
  `attribute3` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ATTRIBUTE3',
  `attribute4` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ATTRIBUTE4',
  `jobcode` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'JOBCODE',
  `deptid0` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'DEPTID0',
  `effseq` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'EFFSEQ',
  `company_descr` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'COMPANY_DESCR',
  `empl_rcd` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'EMPL_RCD',
  `status` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'STATUS',
  `mdm_id` bigint(20) NULL DEFAULT NULL COMMENT 'MDM_ID',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL DEFAULT 0 COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  `lstupdt_date_str` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'lstupdt_date_str',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `sec_bu_id_index`(`sec_bu_id`) USING BTREE,
  INDEX `sec_user_id_index`(`sec_user_id`) USING BTREE,
  INDEX `sec_ou_id_index`(`sec_ou_id`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE
) COMMENT = '同步人员组织关系' ;

-- ----------------------------
-- Table structure for mdm_sync_ou_bu
-- ----------------------------
CREATE TABLE IF NOT EXISTS `mdm_sync_ou_bu`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  `lstupdt_date` datetime(0) NULL DEFAULT NULL COMMENT 'LSTUPDT_DATE',
  `lastupddttm` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'LASTUPDDTTM',
  `cg_dept_area` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'CG_DEPT_AREA',
  `setid_location` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SETID_LOCATION',
  `cg_man_jbcd_descr` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'CG_MAN_JBCD_DESCR',
  `effdt` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'EFFDT',
  `cg_dept_parent` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'CG_DEPT_PARENT',
  `uuid` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'UUID',
  `eff_status` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'EFF_STATUS',
  `cg_gint_dept_level` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'CG_GINT_DEPT_LEVEL',
  `setid_dept` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SETID_DEPT',
  `set_id` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SET_ID',
  `cg_dept_virtual` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'CG_DEPT_VIRTUAL',
  `start_time` datetime(0) NULL DEFAULT NULL COMMENT 'START_TIME',
  `cg_dept_type` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'CG_DEPT_TYPE',
  `cg_is_company` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'CG_IS_COMPANY',
  `dept_id` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'DEPT_ID',
  `manager_id` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'MANAGER_ID',
  `dep_name` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'DEP_NAME',
  `cg_dept_addr` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'CG_DEPT_ADDR',
  `dep_s_name` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'DEP_S_NAME',
  `descr` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'descr',
  `cg_dept_cmp_lvl` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'CG_DEPT_CMP_LVL',
  `attribute5` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ATTRIBUTE5',
  `attribute4` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ATTRIBUTE4',
  `cg_dept_path` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'CG_DEPT_PATH',
  `descrshort` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'DESCRSHORT',
  `attribute7` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ATTRIBUTE7',
  `attribute6` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ATTRIBUTE6',
  `attribute1` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ATTRIBUTE1',
  `descr2` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'DESCR2',
  `attribute3` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ATTRIBUTE3',
  `cg_dept_sort` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'CG_DEPT_SORT',
  `location` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'LOCATION',
  `attribute2` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ATTRIBUTE2',
  `deptid2` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'DEPTID2',
  `company_descr` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'COMPANY_DESCR',
  `status` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'STATUS',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL DEFAULT 0 COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  `is_sync` tinyint(1) NULL DEFAULT NULL COMMENT '是否同步过：1是，0否',
  `company_id` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'COMPANY_ID',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `sec_bu_id_index`(`sec_bu_id`) USING BTREE,
  INDEX `sec_user_id_index`(`sec_user_id`) USING BTREE,
  INDEX `sec_ou_id_index`(`sec_ou_id`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE
) COMMENT = '同步MDM组织/部门信息' ;

-- ----------------------------
-- Table structure for meta_cat_table
-- ----------------------------
CREATE TABLE IF NOT EXISTS `meta_cat_table`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `def_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '定义码',
  `def_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '定义名称',
  `table_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据库表名',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NULL DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `UK_f2o2m2jqmbbqa2l6kiukwdnov`(`def_code`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE
) COMMENT = '自选分类表定义' ;

-- ----------------------------
-- Table structure for meta_catdef
-- ----------------------------
CREATE TABLE IF NOT EXISTS `meta_catdef`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `table_id` bigint(20) NULL DEFAULT NULL COMMENT '自选分类表定义ID',
  `table_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '自选分类表定义编码',
  `field_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据库字段名称',
  `sort_no` int(11) NULL DEFAULT NULL COMMENT '顺序号',
  `domain_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'UDC领域码',
  `udc_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'UDC分类码',
  `default_udc_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '默认UDC名称',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NULL DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE
) COMMENT = '自选分类定义' ;

-- ----------------------------
-- Table structure for meta_column
-- ----------------------------
CREATE TABLE IF NOT EXISTS `meta_column`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `table_id` bigint(20) NULL DEFAULT NULL COMMENT '表记录ID',
  `table_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '表编码',
  `field_id` bigint(20) NULL DEFAULT NULL COMMENT '表字段ID',
  `field_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '表字段编码',
  `udc_domain_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'UDC的Domain Code',
  `udc_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'UDC的UDC Code',
  `udc_default_desc` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'UDC默认描述',
  `page_element` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '页面元素类型',
  `page_label` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '页面标签',
  `mobile_element` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '移动端页面元素类型',
  `mobile_label` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '移动端页面标签',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NULL DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE
) COMMENT = '表列定义' ;

-- ----------------------------
-- Table structure for meta_field
-- ----------------------------
CREATE TABLE IF NOT EXISTS `meta_field`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `field_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '字段编码',
  `field_desc` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '字段描述',
  `field_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '字段类型, [UDC]META:FLDTYPE',
  `field_length` int(11) NULL DEFAULT NULL COMMENT '字段长度',
  `field_precision` int(11) NULL DEFAULT NULL COMMENT '字段精度',
  `udc_domain_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'UDC的Domain Code',
  `udc_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'UDC的UDC Code',
  `udc_default_desc` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'UDC默认描述',
  `page_element` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '页面元素类型',
  `page_label` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '页面标签',
  `mobile_element` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '移动端页面元素类型',
  `mobile_label` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '移动端页面标签',
  `is_required` int(11) NULL DEFAULT NULL COMMENT '是否必填',
  `min_length` int(11) NULL DEFAULT NULL COMMENT '最小长度',
  `max_length` int(11) NULL DEFAULT NULL COMMENT '最大长度',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NULL DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `UK_h0phiq4sx4vbjtqwo004nf73x`(`field_code`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE
) COMMENT = '元数据字段定义' ;

-- ----------------------------
-- Table structure for meta_table
-- ----------------------------
CREATE TABLE IF NOT EXISTS `meta_table`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `table_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '表编码',
  `table_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '表名称',
  `prefix` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '表前缀',
  `table_comment` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '表描述',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NULL DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `UK_ie9ju34cfwnc535sxuitjjmx2`(`table_code`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE
) COMMENT = '元数据表定义' ;

-- ----------------------------
-- Table structure for org_addr
-- ----------------------------
CREATE TABLE IF NOT EXISTS `org_addr`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  `bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'BU_ID',
  `bu_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'BU编号',
  `bu_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'BU名称',
  `addr_no` bigint(20) NOT NULL COMMENT '地址号',
  `line_no` int(20) NULL DEFAULT NULL COMMENT '行号',
  `addr_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '地址薄编号',
  `addr_type` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '地址薄类型:[UDC]ORG:ADDR_TYPE',
  `addr_type2` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '地址薄类型2',
  `addr_type3` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '地址薄类型3',
  `addr_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '地址薄名称',
  `addr_abbr` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '地址薄简称',
  `addr_status` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '地址薄状态',
  `addr_status2` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '地址薄状态2',
  `addr_status3` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '地址薄状态3',
  `legal_addr_no` bigint(20) NULL DEFAULT NULL COMMENT '法人地址号',
  `src_cls` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '来源类别',
  `src_id` bigint(20) NULL DEFAULT NULL COMMENT '来源ID',
  `outer_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '外部编码',
  `es1` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES1',
  `es2` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES2',
  `es3` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES3',
  `es4` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES4',
  `es5` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES5',
  `es6` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES6',
  `es7` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES7',
  `es8` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES8',
  `es9` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES9',
  `es10` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES10',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  `uni_cert_no` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '统一社会信用代码',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_org_addr_no`(`addr_no`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE,
  INDEX `sec_bu_id_index`(`sec_bu_id`) USING BTREE,
  INDEX `sec_user_id_index`(`sec_user_id`) USING BTREE,
  INDEX `sec_ou_id_index`(`sec_ou_id`) USING BTREE
) COMMENT = '地址簿' ;

-- ----------------------------
-- Table structure for org_addr_address
-- ----------------------------
CREATE TABLE IF NOT EXISTS `org_addr_address`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  `bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'BU_ID',
  `bu_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'BU编号',
  `bu_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'BU名称',
  `addr_no` bigint(20) NOT NULL COMMENT '地址号',
  `line_no` int(20) NULL DEFAULT NULL COMMENT '行号',
  `address_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '地址名称',
  `address_type` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '地址类型(指送货地址，开票地址等):[UDC]ORG:ADDRESS_TYPE',
  `address_type2` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '地址类型2',
  `default_flag` tinyint(1) NULL DEFAULT NULL COMMENT '是否默认：1是，0否',
  `address_status` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '地址状态',
  `cont_person` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '联系人姓名',
  `mobile` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '手机号码',
  `mobile2` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '手机号码2',
  `tel` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '电话',
  `tel2` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '电话2',
  `fax` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '传真',
  `email` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '电邮',
  `email2` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '电邮2',
  `country` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '国家',
  `province` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '省份',
  `city` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '城市',
  `county` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '区县',
  `street` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '街道/乡镇',
  `detail_addr` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '详细地址',
  `tp_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '默认运输方式',
  `x_lon` decimal(10, 6) NULL DEFAULT NULL COMMENT '经度',
  `y_lat` decimal(10, 6) NULL DEFAULT NULL COMMENT '纬度',
  `coord_type` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '经纬度标准',
  `zip_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '邮政编码',
  `web_address` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '网址',
  `weibo` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '微博',
  `wechat_mp` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '微信公众号',
  `other_info1` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '其它联系信息1',
  `other_info2` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '其它联系信息2',
  `other_info3` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '其它联系信息3',
  `position` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '职位',
  `pid` bigint(20) NULL DEFAULT NULL COMMENT '上级联系人ID',
  `es1` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES1',
  `es2` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES2',
  `es3` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES3',
  `es4` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES4',
  `es5` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES5',
  `es6` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES6',
  `es7` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES7',
  `es8` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES8',
  `es9` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES9',
  `es10` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES10',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  `data_source` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据来源',
  `qq_no` varchar(32) CHARACTER SET utf8mb4 DEFAULT NULL COMMENT 'qq号',
  `we_chat_no` varchar(32) CHARACTER SET utf8mb4 DEFAULT NULL COMMENT '微信号',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE,
  INDEX `sec_bu_id_index`(`sec_bu_id`) USING BTREE,
  INDEX `sec_user_id_index`(`sec_user_id`) USING BTREE,
  INDEX `sec_ou_id_index`(`sec_ou_id`) USING BTREE
) COMMENT = '地址簿地址信息' ;

-- ----------------------------
-- Table structure for org_addr_bank_acc
-- ----------------------------
CREATE TABLE IF NOT EXISTS `org_addr_bank_acc`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  `thirdparty_virtual_user_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '第三方虚拟用户ID',
  `thirdparty_virtual_acc` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '第三方虚拟帐户',
  `bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'BU_ID',
  `bu_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'BU编号',
  `bu_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'BU名称',
  `addr_no` bigint(20) NOT NULL COMMENT '地址号',
  `line_no` int(20) NULL DEFAULT NULL COMMENT '行号',
  `acc_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '账号编号',
  `acc_type` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '账号类型:[UDC]ORG:ADDR_BANKACC_TYPE',
  `default_flag` tinyint(1) NULL DEFAULT NULL COMMENT '是否默认：1是，0否',
  `bank_id` bigint(20) NULL DEFAULT NULL COMMENT '银行ID',
  `bank_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '银行编号',
  `bank_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '银行名称',
  `branch_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '网点名称',
  `bank_acc` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '开户行账号',
  `holder_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '开户人姓名',
  `curr_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '币种',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  `bank_account_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '开户行账户名称',
  `bank_account_comp` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '开户行账户组合',
  `pay_collect_method` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '收付款方式 [UDC]COM:PAY_METHOD',
  `data_source` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据来源',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE,
  INDEX `sec_bu_id_index`(`sec_bu_id`) USING BTREE,
  INDEX `sec_user_id_index`(`sec_user_id`) USING BTREE,
  INDEX `sec_ou_id_index`(`sec_ou_id`) USING BTREE
) COMMENT = '地址簿银行账号信息' ;

-- ----------------------------
-- Table structure for org_addr_copy1
-- ----------------------------
CREATE TABLE IF NOT EXISTS `org_addr_copy1`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  `bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'BU_ID',
  `bu_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'BU编号',
  `bu_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'BU名称',
  `addr_no` bigint(20) NOT NULL COMMENT '地址号',
  `line_no` int(20) NULL DEFAULT NULL COMMENT '行号',
  `addr_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '地址薄编号',
  `addr_type` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '地址薄类型:[UDC]ORG:ADDR_TYPE',
  `addr_type2` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '地址薄类型2',
  `addr_type3` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '地址薄类型3',
  `addr_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '地址薄名称',
  `addr_abbr` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '地址薄简称',
  `addr_status` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '地址薄状态',
  `addr_status2` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '地址薄状态2',
  `addr_status3` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '地址薄状态3',
  `legal_addr_no` bigint(20) NULL DEFAULT NULL COMMENT '法人地址号',
  `src_cls` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '来源类别',
  `src_id` bigint(20) NULL DEFAULT NULL COMMENT '来源ID',
  `outer_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '外部编码',
  `es1` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES1',
  `es2` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES2',
  `es3` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES3',
  `es4` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES4',
  `es5` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES5',
  `es6` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES6',
  `es7` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES7',
  `es8` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES8',
  `es9` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES9',
  `es10` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES10',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_org_addr_no`(`addr_no`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE,
  INDEX `sec_bu_id_index`(`sec_bu_id`) USING BTREE,
  INDEX `sec_user_id_index`(`sec_user_id`) USING BTREE,
  INDEX `sec_ou_id_index`(`sec_ou_id`) USING BTREE
) COMMENT = '地址簿' ;

-- ----------------------------
-- Table structure for org_addr_qualify
-- ----------------------------
CREATE TABLE IF NOT EXISTS `org_addr_qualify`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  `bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'BU_ID',
  `bu_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'BU编号',
  `bu_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'BU名称',
  `addr_no` bigint(20) NOT NULL COMMENT '地址号',
  `line_no` int(20) NULL DEFAULT NULL COMMENT '行号',
  `qualify_type` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '资质类型:[UDC]ORG:ADDR_QUALIFY_TYPE',
  `qualify_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '资质名称',
  `qualify_no` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '资质文件编号(文件自己的编号)',
  `qualify_file_id` bigint(20) NULL DEFAULT NULL COMMENT '资质文件ID',
  `qualify_file_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '资质文件名称',
  `qualify_file_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '资质文件编号(上传后系统生成的编号',
  `valid_from` datetime(0) NULL DEFAULT NULL COMMENT '生效日期',
  `valid_to` datetime(0) NULL DEFAULT NULL COMMENT '失效日期',
  `next_check_date` datetime(0) NULL DEFAULT NULL COMMENT '下次检验日期',
  `lang_term_flag` tinyint(1) NULL DEFAULT NULL COMMENT '是否长期有效：1是，0否',
  `qualify_status` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '资质证照状态:[UDC]COM:STATUS_ACTIVEORNO',
  `qualify_status2` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '资质证照状态2',
  `qualify_owner` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '证照所有者',
  `es1` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES1',
  `es2` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES2',
  `es3` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES3',
  `es4` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES4',
  `es5` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES5',
  `es6` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES6',
  `es7` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES7',
  `es8` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES8',
  `es9` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES9',
  `es10` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES10',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  `data_source` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据来源',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE,
  INDEX `sec_bu_id_index`(`sec_bu_id`) USING BTREE,
  INDEX `sec_user_id_index`(`sec_user_id`) USING BTREE,
  INDEX `sec_ou_id_index`(`sec_ou_id`) USING BTREE
) COMMENT = '地址簿资质信息' ;

-- ----------------------------
-- Table structure for org_address_book
-- ----------------------------
CREATE TABLE IF NOT EXISTS `org_address_book`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
  `address_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '地址簿类型:[UDC]ORG:ADDR_TYPE',
  `record_id` bigint(20) NULL DEFAULT NULL COMMENT '记录ID',
  `is_primary` int(11) NULL DEFAULT NULL COMMENT '是否主记录，类似默认',
  `country` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '国家',
  `province` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '省份',
  `city` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '城市',
  `county` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '区县',
  `community` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '街道',
  `address_line` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '详细地址',
  `postal_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '邮政编码',
  `contact` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '联系人',
  `mobile` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '手机号码',
  `link_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '联系关系:[UDC]ORG:v ',
  `bank_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '开户行',
  `bank_account` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '银行账号',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NULL DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE
)  COMMENT = '地址簿' ;

-- ----------------------------
-- Table structure for org_area
-- ----------------------------
CREATE TABLE IF NOT EXISTS `org_area`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'OU_ID',
  `bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'BU_ID',
  `bu_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'BU编号',
  `bu_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'BU名称',
  `province` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '省份',
  `city` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '城市',
  `county` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '区县',
  `street` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '街道/乡镇',
  `detail_addr` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '详细地址',
  `nationwide_sts` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '详细地址',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  PRIMARY KEY (`id`) USING BTREE
) COMMENT = '公司行政区划' ;

-- ----------------------------
-- Table structure for org_attachment
-- ----------------------------
CREATE TABLE IF NOT EXISTS `org_attachment`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  `org_id` bigint(20) NULL DEFAULT NULL COMMENT '组织中心内模块对应的ID',
  `file_id` bigint(20) NULL DEFAULT NULL COMMENT '文件ID',
  `file_name` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '文件名称',
  `file_code` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '文件编号',
  `file_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '文件类型(图片，附件等)',
  `img_size` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '图片尺寸',
  `file_size` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '文件大小',
  `major` tinyint(1) NULL DEFAULT NULL COMMENT '是否主图',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  `url` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '图片url',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE,
  INDEX `sec_bu_id_index`(`sec_bu_id`) USING BTREE,
  INDEX `sec_user_id_index`(`sec_user_id`) USING BTREE,
  INDEX `sec_ou_id_index`(`sec_ou_id`) USING BTREE
) COMMENT = '商品附件' ;

-- ----------------------------
-- Table structure for org_bg_bu
-- ----------------------------
CREATE TABLE IF NOT EXISTS `org_bg_bu`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE,
  INDEX `sec_bu_id_index`(`sec_bu_id`) USING BTREE,
  INDEX `sec_user_id_index`(`sec_user_id`) USING BTREE,
  INDEX `sec_ou_id_index`(`sec_ou_id`) USING BTREE
) COMMENT = 'BU组与BU' ;

-- ----------------------------
-- Table structure for org_bu
-- ----------------------------
CREATE TABLE IF NOT EXISTS `org_bu`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  `bu_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'BU编号',
  `bu_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'BU名称',
  `bu_name2` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'BU名称2',
  `bu_name3` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'BU名称3',
  `bu_name4` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'BU名称4',
  `bu_abbr` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'BU简称',
  `bu_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'BU类型',
  `bu_type2` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '店铺类型 [UDC]ORG:BU_TYPE2',
  `bu_type3` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'BU类型3',
  `bu_type4` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'BU类型4',
  `bu_type5` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'BU类型5',
  `bu_type6` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'BU类型6',
  `bu_type7` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'BU类型7',
  `bu_status` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'BU状态 [UDC]COM:STATUS_BU',
  `bu_status2` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'BU状态2',
  `bu_status3` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'BU状态3',
  `ou_id` bigint(20) NULL DEFAULT NULL COMMENT '公司ID',
  `ou_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '公司编号',
  `ou_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '公司名称',
  `pid` bigint(20) NULL DEFAULT NULL COMMENT '上级ID',
  `bu_path` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '关系路径',
  `addr_no` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '地址号',
  `bu_level` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'BU层级 [UDC]ORG:BU_LEVEL',
  `bu_region` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '区域 [UDC]COM:REGION',
  `sort_no` int(11) NULL DEFAULT NULL COMMENT '排序号码',
  `pic_emp_id` bigint(20) NULL DEFAULT NULL COMMENT '负责人员工ID',
  `pic_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '负责人姓名',
  `cat` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码',
  `cat2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码2',
  `cat3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码3',
  `cat4` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码4',
  `cat5` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码5',
  `cat6` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码6',
  `cat7` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码7',
  `cat8` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码8',
  `cat9` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码9',
  `cat10` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码10',
  `cat11` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码11',
  `cat12` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码12',
  `cat13` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码13',
  `cat14` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码14',
  `cat15` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码15',
  `cat16` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码16',
  `cat17` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码17',
  `cat18` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码18',
  `cat19` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码19',
  `cat20` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码20',
  `cat21` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码21',
  `cat22` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码22',
  `cat23` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码23',
  `cat24` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码24',
  `cat25` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码25',
  `cat26` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码26',
  `cat27` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码27',
  `cat28` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码28',
  `cat29` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码29',
  `cat30` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码30',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  `cost_centre_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '成本中心编码',
  `cost_centre_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '成本中心名称',
  `jdy_flag` int(11) NULL DEFAULT NULL COMMENT '是否同步激荡云',
  `data_source` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据来源',
  `sync_status` tinyint(1) NULL DEFAULT 0 COMMENT '同步的数据是否需要覆盖 false:忽略  true:覆盖',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE,
  INDEX `sec_bu_id_index`(`sec_bu_id`) USING BTREE,
  INDEX `sec_user_id_index`(`sec_user_id`) USING BTREE,
  INDEX `sec_ou_id_index`(`sec_ou_id`) USING BTREE
) COMMENT = 'BU' ;

-- ----------------------------
-- Table structure for org_bu_cust
-- ----------------------------
CREATE TABLE IF NOT EXISTS `org_bu_cust`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
  `cust_id` bigint(20) NULL DEFAULT 0 COMMENT '公司ID',
  `bu_id` bigint(20) NULL DEFAULT 0 COMMENT 'BUID',
  `bu_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'buCode',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NULL DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE
)  COMMENT = '客户经销商中间表' ;

-- ----------------------------
-- Table structure for org_bu_emp
-- ----------------------------
CREATE TABLE IF NOT EXISTS `org_bu_emp`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
  `bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'BU记录ID',
  `emp_id` bigint(20) NULL DEFAULT NULL COMMENT '雇员记录ID',
  `bu_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '关联类型',
  `post_udc_val` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '岗位udcVal',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NULL DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE
)  COMMENT = '雇员信息' ;

-- ----------------------------
-- Table structure for org_bu_employee
-- ----------------------------
CREATE TABLE IF NOT EXISTS `org_bu_employee`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
  `bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'BU记录ID',
  `employee_id` bigint(20) NULL DEFAULT NULL COMMENT '雇员记录ID',
  `link_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '关联类型',
  `post_id` bigint(20) NULL DEFAULT NULL COMMENT '岗位记录ID',
  `post_weight` double NULL DEFAULT NULL COMMENT '部门岗位权重',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NULL DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE
)  COMMENT = '雇员BU关联表' ;

-- ----------------------------
-- Table structure for org_bu_ref
-- ----------------------------
CREATE TABLE IF NOT EXISTS `org_bu_ref`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE,
  INDEX `sec_bu_id_index`(`sec_bu_id`) USING BTREE,
  INDEX `sec_user_id_index`(`sec_user_id`) USING BTREE,
  INDEX `sec_ou_id_index`(`sec_ou_id`) USING BTREE
) COMMENT = '组织关联' ;

-- ----------------------------
-- Table structure for org_bu_tree
-- ----------------------------
CREATE TABLE IF NOT EXISTS `org_bu_tree`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  `bu_tree_type` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '组织树类型',
  `bu_tree_type2` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '组织树类型2',
  `bu_tree_type3` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '组织树类型3',
  `bu_tree_status` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '组织树状态',
  `bu_tree_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '组织树编号',
  `bu_tree_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '组织树名称',
  `bu_tree_version` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '组织树版本',
  `now_version` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '组织树当前版本',
  `cat` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码',
  `cat2` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码2',
  `cat3` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码3',
  `cat4` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码4',
  `cat5` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码5',
  `cat6` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码6',
  `cat7` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码7',
  `cat8` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码8',
  `cat9` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码9',
  `cat10` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码10',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  `release_time` datetime(6) NULL DEFAULT NULL COMMENT '发布时间',
  `is_now_version` bit(1) NULL DEFAULT NULL COMMENT '是否当前版本',
  `disable_time` datetime(6) NULL DEFAULT NULL COMMENT '停用时间',
  `release_user` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '发布人',
  `version_instruction` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '版本说明',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE,
  INDEX `sec_bu_id_index`(`sec_bu_id`) USING BTREE,
  INDEX `sec_user_id_index`(`sec_user_id`) USING BTREE,
  INDEX `sec_ou_id_index`(`sec_ou_id`) USING BTREE
) COMMENT = '组织树' ;

-- ----------------------------
-- Table structure for org_bu_tree_d
-- ----------------------------
CREATE TABLE IF NOT EXISTS `org_bu_tree_d`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  `bu_tree_id` bigint(20) NULL DEFAULT NULL COMMENT '组织树ID',
  `bu_id` bigint(20) NULL DEFAULT NULL COMMENT '组织ID',
  `pid` bigint(20) NULL DEFAULT NULL COMMENT '上级ID',
  `bu_path` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '路径',
  `bu_level` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '组织层级',
  `sort_no` int(11) NULL DEFAULT NULL COMMENT '排序',
  `level` int(8) NULL DEFAULT NULL COMMENT '级别',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  `code_path` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `bu_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `data_source` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据来源',
  `sync_status` tinyint(1) NULL DEFAULT 0 COMMENT '同步的数据是否需要覆盖 false:忽略  true:覆盖',
  `jdy_flag` int(11) NULL DEFAULT NULL COMMENT '是否同步激荡云 默认:1',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_bu_tree_pid`(`pid`) USING BTREE,
  INDEX `idx_bu_tree_code_path`(`code_path`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE,
  INDEX `sec_bu_id_index`(`sec_bu_id`) USING BTREE,
  INDEX `sec_user_id_index`(`sec_user_id`) USING BTREE,
  INDEX `sec_ou_id_index`(`sec_ou_id`) USING BTREE
) COMMENT = '组织树明细' ;

-- ----------------------------
-- Table structure for org_bu_tree_version
-- ----------------------------
CREATE TABLE IF NOT EXISTS `org_bu_tree_version`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE,
  INDEX `sec_bu_id_index`(`sec_bu_id`) USING BTREE,
  INDEX `sec_user_id_index`(`sec_user_id`) USING BTREE,
  INDEX `sec_ou_id_index`(`sec_ou_id`) USING BTREE
) COMMENT = '组织树版本' ;

-- ----------------------------
-- Table structure for org_cust
-- ----------------------------
CREATE TABLE IF NOT EXISTS `org_cust`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
  `ou_id` bigint(20) NULL DEFAULT 0 COMMENT '公司ID',
  `bu_id` bigint(20) NULL DEFAULT 0 COMMENT 'BUID',
  `cust_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '客户编号',
  `cust_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '客户名称',
  `cust_name2` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '客户名称2',
  `cust_abbr` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '客户简称',
  `cust_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '客户类型 [UDC]ORG:CUST_TYPE',
  `cust_type2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '客户类型2 [UDC]ORG:CUST_TYPE2',
  `cust_type3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '客户类型3 [UDC]ORG:CUST_TYPE3',
  `cust_type4` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '客户类型4',
  `cust_type5` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '客户类型5',
  `cust_status` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '客户状态 ORG:CUST_STATUS',
  `cust_status2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '客户状态2',
  `cust_status3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '客户状态3',
  `cust_group` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '客户组别',
  `cust_group2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '客户组别2',
  `cust_group3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '客户组别3',
  `cust_group4` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '客户组别4',
  `c1_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '大类编号 使用COM_C1表',
  `c2_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '中类编号 使用COM_C2表',
  `c3_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '小类编号',
  `pid` bigint(20) NULL DEFAULT 0 COMMENT '上级ID',
  `cust_path` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '路径',
  `pinyin` varchar(800) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '拼音',
  `pinyin_sh` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '拼音简称',
  `comp_capital` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '资金能力',
  `agent_emp_id` bigint(20) NULL DEFAULT 0 COMMENT '业务员员工ID',
  `pay_method` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '付款方式',
  `cust_curr` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '币种',
  `credit_level` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '信贷级别 [UDC]COM:CREDIT_LEVEL',
  `credit_limit` decimal(20, 2) NULL DEFAULT NULL COMMENT '信用额度',
  `credit_bal` decimal(20, 2) NULL DEFAULT NULL COMMENT '信用余额',
  `credit_check_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '信贷检查类型 [UDC]COM:CREDIT_CHECK_TYPE',
  `payment_term` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '支付条款',
  `settle_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '结算方式',
  `recon_period` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '对账周期',
  `settle_monthly_day` int(11) NULL DEFAULT NULL COMMENT '月结日期',
  `def_bu_id` bigint(20) NULL DEFAULT 0 COMMENT '默认BUID',
  `def_wh_id` bigint(20) NULL DEFAULT 0 COMMENT '默认仓库ID',
  `country` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '国家',
  `postcode` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '邮编',
  `region` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '区域',
  `cust_level` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '客户等级',
  `channel_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '渠道类型 [UDC]COM:CHANNEL_TYPE',
  `channel_type2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '渠道类型2 [UDC]COM:CHANNEL_TYPE2',
  `ka_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'KA类型',
  `store_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '门店类型',
  `vip_no` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '会员号码',
  `vip_level` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '会员级别',
  `vip_group` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '会员组别',
  `cust_point_flag` int(11) NULL DEFAULT NULL COMMENT '是否积分',
  `point_balance` decimal(10, 2) NULL DEFAULT NULL COMMENT '积分余额',
  `cust_source` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '客户来源',
  `valid_from` datetime(0) NULL DEFAULT NULL COMMENT '生效日期',
  `valid_to` datetime(0) NULL DEFAULT NULL COMMENT '失效日期',
  `tax_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '税区',
  `tax_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '税码',
  `taxpayer_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '纳税人类型',
  `taxer_no` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '税号',
  `inv_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '发票类型 [UDC]COM:INV_TYPE',
  `inv_title` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '开票抬头',
  `inv_address` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '开票地址',
  `inv_pic_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '开票联系人',
  `inv_pic_phone` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '开票联系人电话',
  `inv_tel` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '开票电话',
  `inv_bank_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '开票银行名称',
  `inv_bank_branch` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '开票银行支行',
  `inv_bank_acc` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '开票银行账号',
  `tax_rate_no` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '税率编号',
  `tax_rate` decimal(20, 8) NULL DEFAULT NULL COMMENT '税率',
  `fin_gl_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '总账类型 [UDC]ORG:CUST_GL_TYPE',
  `ic_register_no` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '工商登记号',
  `register_date` datetime(0) NULL DEFAULT NULL COMMENT '注册日期',
  `register_address` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '注册地址',
  `register_trademark_no` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '注册商标编号',
  `register_fund` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '注册资金',
  `register_fund_curry` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '注册资金货币',
  `ic_issued` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '工商登记注册机关',
  `ic_issued_date` datetime(0) NULL DEFAULT NULL COMMENT '工商登记日期',
  `biz_code_cert` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '组织机构代码证',
  `biz_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '机构类型',
  `biz_issued` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '组织机构代码证颁发单位',
  `cert_no` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '统一信用代码',
  `tax_reg_no` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '税务登记证编号',
  `taxpayer_id` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '纳税人识别号',
  `repr` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '法人代表',
  `repr_cert_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '法人证件类型',
  `repr_cert_no` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '法人证件编号',
  `repr_cert_mobile` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '法人手机号',
  `comp_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '公司名称',
  `comp_prop` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '公司性质',
  `comp_scale` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '公司规模',
  `comp_bussaddr` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '经营地点',
  `comp_mainbuss` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '主营业务',
  `comp_bussrange` varchar(2000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '经营范围',
  `outer_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '外部编码',
  `tags` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '标签',
  `es1` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES1',
  `es2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES2',
  `es3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES3',
  `es4` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES4',
  `es5` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES5',
  `es6` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES6',
  `es7` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES7',
  `es8` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES8',
  `es9` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES9',
  `es10` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES10',
  `pc_id` bigint(20) NULL DEFAULT 0 COMMENT '利润中心',
  `allow_over_aap` int(11) NULL DEFAULT NULL COMMENT '允许超允收期',
  `allow_pp_inv` int(11) NULL DEFAULT NULL COMMENT '允许卫检单后补',
  `tax_incl_flag` int(11) NULL DEFAULT NULL COMMENT '是否含税',
  `max_lot_num` int(11) NULL DEFAULT NULL COMMENT '允许最大批次数量',
  `intf_status` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '接口状态',
  `intf_time` datetime(0) NULL DEFAULT NULL COMMENT '接口处理时间',
  `open_so_amt` decimal(20, 2) NULL DEFAULT NULL COMMENT '活动订单金额',
  `en1` float(20, 2) NULL DEFAULT NULL COMMENT '预留浮点数1',
  `en2` float(20, 2) NULL DEFAULT NULL COMMENT '预留浮点数2',
  `en3` float(20, 2) NULL DEFAULT NULL COMMENT '预留浮点数3',
  `en4` float(20, 2) NULL DEFAULT NULL COMMENT '预留浮点数4',
  `en5` float(20, 2) NULL DEFAULT NULL COMMENT '预留浮点数5',
  `co_flag` tinyint(1) NULL DEFAULT 0 COMMENT '是否有退货合同 0：否；1：是',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NULL DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `MyIndex1`(`cust_code`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE
)  COMMENT = '客户' ;

-- ----------------------------
-- Table structure for org_emp
-- ----------------------------
CREATE TABLE IF NOT EXISTS `org_emp`  (
  `id` bigint(20) NOT NULL,
  `sec_bu_id` bigint(20) NULL DEFAULT NULL,
  `sec_user_id` bigint(20) NULL DEFAULT NULL,
  `sec_ou_id` bigint(20) NULL DEFAULT NULL,
  `pid` bigint(20) NOT NULL,
  `sort_no` int(11) NULL DEFAULT NULL,
  `level` int(11) NULL DEFAULT NULL,
  `id_path` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `code_path` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `ou_id` bigint(20) NULL DEFAULT NULL COMMENT '公司ID',
  `ou_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '公司编号',
  `ou_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '公司名称',
  `bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'BU ID',
  `bu_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'BU编号',
  `bu_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'BU名称',
  `emp_bu_id` bigint(20) NULL DEFAULT NULL COMMENT '员工所属 BU ID',
  `emp_bu_tree_id` bigint(20) NULL DEFAULT NULL COMMENT '员工所属BU树ID',
  `emp_bu_treedid` bigint(20) NULL DEFAULT NULL COMMENT '员工所属BU树详情ID',
  `user_id` bigint(20) NULL DEFAULT NULL COMMENT '用户id',
  `user_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '用户名',
  `emp_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '雇员编号',
  `emp_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '雇员姓名',
  `emp_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '员工类型 [UDC]ORG:EMP_TYPE',
  `emp_type2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '员工类型2',
  `emp_type3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '员工类型3',
  `emp_status` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '员工状态 [UDC]ORG:EMP_STATUS',
  `foreign_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '雇员外文名',
  `addr_no` bigint(20) NULL DEFAULT NULL COMMENT '地址号',
  `emp_gender` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '员工性别',
  `birth_date` datetime(6) NULL DEFAULT NULL COMMENT '出生日期',
  `email` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '工作邮箱',
  `mobile` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '工作手机号',
  `id_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '证件类型',
  `id_no` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '证件号码',
  `emp_level` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '职级',
  `title` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '行政职位, [UDC]ORG:TITLE',
  `join_date` datetime(6) NULL DEFAULT NULL COMMENT '入职日期',
  `leave_date` datetime(6) NULL DEFAULT NULL COMMENT '离职日期',
  `tenant_id` bigint(20) NULL DEFAULT NULL,
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `create_user_id` bigint(20) NULL DEFAULT NULL,
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `create_time` datetime(6) NULL DEFAULT NULL,
  `modify_user_id` bigint(20) NULL DEFAULT NULL,
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `modify_time` datetime(6) NULL DEFAULT NULL,
  `delete_flag` int(11) NOT NULL,
  `audit_data_version` int(11) NULL DEFAULT NULL,
  `jdy_flag` int(11) NULL DEFAULT NULL COMMENT '是否同步激荡云',
  `data_source` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据来源',
  `sync_status` tinyint(1) NULL DEFAULT 0 COMMENT '同步的数据是否需要覆盖 false:忽略  true:覆盖',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_emp_pid`(`pid`) USING BTREE,
  INDEX `idx_emp_id_path`(`id_path`) USING BTREE,
  INDEX `idx_emp_code_path`(`code_path`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE,
  INDEX `sec_bu_id_index`(`sec_bu_id`) USING BTREE,
  INDEX `sec_user_id_index`(`sec_user_id`) USING BTREE,
  INDEX `sec_ou_id_index`(`sec_ou_id`) USING BTREE
) COMMENT = '员工' ;

-- ----------------------------
-- Table structure for org_emp_bu
-- ----------------------------
CREATE TABLE IF NOT EXISTS `org_emp_bu`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  `emp_id` bigint(20) NULL DEFAULT NULL COMMENT '员工ID',
  `emp_bu_id` bigint(20) NULL DEFAULT NULL COMMENT '员工绑定组织ID',
  `emp_bu_tree_id` bigint(20) NULL DEFAULT NULL COMMENT '员工绑定的组织树ID',
  `emp_bu_tree_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '员工绑定的组织树编号',
  `emp_bu_treedid` bigint(20) NULL DEFAULT NULL COMMENT '员工绑定的组织树详情ID',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  `data_source` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据来源',
  `sync_status` tinyint(1) NULL DEFAULT 0 COMMENT '同步的数据是否需要覆盖 false:忽略  true:覆盖',
  `primary_bu` tinyint(1) NULL DEFAULT 0 COMMENT '是否主组织',
  `join_time` date NULL DEFAULT NULL COMMENT '加入时间',
  `quit_time` date NULL DEFAULT NULL COMMENT '退出时间',
  `emp_bu_status` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '状态[UDC]ORG:EMP_POS_STATUS',
  `emp_ou_id` bigint(20) NULL DEFAULT NULL COMMENT '员工所属公司ID',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE,
  INDEX `sec_bu_id_index`(`sec_bu_id`) USING BTREE,
  INDEX `sec_user_id_index`(`sec_user_id`) USING BTREE,
  INDEX `sec_ou_id_index`(`sec_ou_id`) USING BTREE
) COMMENT = '员工组织关系表' ;

-- ----------------------------
-- Table structure for org_employee
-- ----------------------------
CREATE TABLE IF NOT EXISTS `org_employee`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
  `emp_no` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '雇员编号',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '雇员姓名',
  `foreign_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '雇员外文名',
  `ou_id` bigint(20) NULL DEFAULT NULL COMMENT '所属OU ID',
  `bu_id` bigint(20) NULL DEFAULT NULL COMMENT '所属BU ID',
  `report_to_id` bigint(20) NULL DEFAULT NULL COMMENT '汇报雇员记录ID',
  `report_to_path` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '汇报ID路径',
  `post_id` bigint(20) NULL DEFAULT NULL COMMENT '岗位记录ID',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '行政职位, [UDC]ORG:TITLE',
  `sys_user_id` bigint(20) NULL DEFAULT NULL COMMENT '系统用户ID',
  `sys_user_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '系统用户账号',
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '工作邮箱',
  `mobile` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '工作手机号',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NULL DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE
)  COMMENT = '雇员信息' ;

-- ----------------------------
-- Table structure for org_employee_tag_ref
-- ----------------------------
CREATE TABLE IF NOT EXISTS `org_employee_tag_ref`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
  `employee_id` bigint(20) NULL DEFAULT NULL COMMENT '雇员记录ID',
  `tag_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '雇员标签名称',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NULL DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE
)  COMMENT = '雇员标签关系表' ;

-- ----------------------------
-- Table structure for org_empoyee_tag
-- ----------------------------
CREATE TABLE IF NOT EXISTS `org_empoyee_tag`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
  `tag_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '标签名称',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NULL DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE
)  COMMENT = '雇员标签表' ;

-- ----------------------------
-- Table structure for org_ou
-- ----------------------------
CREATE TABLE IF NOT EXISTS `org_ou`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  `ou_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '公司编号',
  `ou_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '公司名称',
  `ou_name2` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '公司名称2',
  `ou_name3` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '公司名称3',
  `ou_name4` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '公司名称4',
  `ou_abbr` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '公司简称',
  `abbr_alpha` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '字母缩写',
  `ou_type` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '公司类型 [UDC]ORG:OU_TYPE',
  `ou_type2` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '公司类型2',
  `ou_type3` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '公司类型3',
  `ou_status` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '公司状态 [UDC]COM:STATUS_ACTIVEORNO',
  `ou_status2` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '公司状态2',
  `ou_status3` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '公司状态3',
  `bu_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '经营单位ID',
  `bu_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'BU编号',
  `bu_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'BU名称',
  `pid` bigint(20) NULL DEFAULT NULL COMMENT '上级ID',
  `legal_ou_id` bigint(20) NULL DEFAULT NULL COMMENT '法人公司ID',
  `ou_path` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '路径',
  `ou_curr` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '本位币',
  `fin_cal_code` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '财务日历编号',
  `fin_year` int(20) NULL DEFAULT NULL COMMENT '财务年度',
  `fin_period` int(20) NULL DEFAULT NULL COMMENT '财务期间',
  `addr_no` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '地址号',
  `country` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '国家 [UDC]COM:COUNTRY',
  `region` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '区域 [UDC]ORG:OU_REGION',
  `sort_no` int(11) NULL DEFAULT NULL COMMENT '排序号 用于相同层级的排序',
  `biz_code_cert` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '组织机构代码证号',
  `ic_register_no` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '工商登记号',
  `uni_cert_no` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '统一信用代码',
  `repr_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '法人代表',
  `tax_reg_no` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '税务登记号',
  `taxpayer_type` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '纳税人类型',
  `taxer_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '纳税人识别号',
  `inv_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '发票类型',
  `inv_title` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '开票抬头',
  `inv_address` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '开票地址',
  `inv_tel` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '开票电话',
  `inv_pic_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '开票联系人',
  `inv_pic_phone` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '开票联系人电话',
  `inv_bank_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '开票银行名称',
  `inv_bank_branch` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '开票银行支行',
  `inv_bank_acc` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '开票银行账号',
  `tax_rate_no` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '税率编号',
  `tax_rate` decimal(18, 4) NULL DEFAULT NULL COMMENT '税率',
  `cat` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码',
  `cat2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码2',
  `cat3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码3',
  `cat4` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码4',
  `cat5` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码5',
  `cat6` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码6',
  `cat7` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码7',
  `cat8` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码8',
  `cat9` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码9',
  `cat10` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码10',
  `cat11` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码11',
  `cat12` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码12',
  `cat13` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码13',
  `cat14` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码14',
  `cat15` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码15',
  `cat16` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码16',
  `cat17` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码17',
  `cat18` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码18',
  `cat19` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码19',
  `cat20` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码20',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  `external_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '核算编码',
  `data_source` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据来源',
  `sync_status` tinyint(1) NULL DEFAULT 0 COMMENT '同步的数据是否需要覆盖 false:忽略  true:覆盖',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE,
  INDEX `sec_bu_id_index`(`sec_bu_id`) USING BTREE,
  INDEX `sec_user_id_index`(`sec_user_id`) USING BTREE,
  INDEX `sec_ou_id_index`(`sec_ou_id`) USING BTREE
) COMMENT = '公司' ;

-- ----------------------------
-- Table structure for org_post
-- ----------------------------
CREATE TABLE IF NOT EXISTS `org_post`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
  `post_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '岗位编码',
  `post_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '岗位名称',
  `post_weight` int(11) NULL DEFAULT NULL COMMENT '岗位权重',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NULL DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE
)  COMMENT = '岗位主信息' ;

-- ----------------------------
-- Table structure for org_store
-- ----------------------------
CREATE TABLE IF NOT EXISTS `org_store`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  `ou_id` bigint(20) NULL DEFAULT NULL,
  `ou_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '公司编号',
  `ou_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '公司名称',
  `bu_id` bigint(20) NULL DEFAULT NULL,
  `bu_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `bu_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `store_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `store_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `store_name2` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `store_abbr` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `store_type` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `store_type2` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `store_type3` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `store_status` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `store_status2` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `store_status3` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `addr_no` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '地址号',
  `region` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '区域',
  `sort_no` int(11) NULL DEFAULT NULL,
  `pic_user_id` bigint(20) NULL DEFAULT NULL,
  `pic_emp_id` bigint(20) NULL DEFAULT NULL,
  `pic_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `open_time_span` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `open_time_span2` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `start_date` date NULL DEFAULT NULL,
  `end_date` date NULL DEFAULT NULL,
  `pid` bigint(20) NULL DEFAULT NULL COMMENT '上级ID',
  `store_path` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `cat` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码',
  `cat2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码2',
  `cat3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码3',
  `cat4` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码4',
  `cat5` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码5',
  `cat6` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码6',
  `cat7` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码7',
  `cat8` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码8',
  `cat9` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码9',
  `cat10` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码10',
  `cat11` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码11',
  `cat12` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码12',
  `cat13` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码13',
  `cat14` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码14',
  `cat15` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码15',
  `cat16` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码16',
  `cat17` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码17',
  `cat18` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码18',
  `cat19` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码19',
  `cat20` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码20',
  `cat21` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码21',
  `cat22` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码22',
  `cat23` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码23',
  `cat24` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码24',
  `cat25` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码25',
  `cat26` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码26',
  `cat27` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码27',
  `cat28` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码28',
  `cat29` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码29',
  `cat30` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类别码30',
  `outer_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '外部编码',
  `outer_code2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '外部编码2',
  `es1` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES1',
  `es2` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES2',
  `es3` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES3',
  `es4` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES4',
  `es5` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES5',
  `es6` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES6',
  `es7` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES7',
  `es8` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES8',
  `es9` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES9',
  `es10` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'ES10',
  `ed1` date NULL DEFAULT NULL COMMENT 'ED1',
  `ed2` date NULL DEFAULT NULL COMMENT 'ED2',
  `ed3` date NULL DEFAULT NULL COMMENT 'ED3',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  `accumulated_conn_user_number` int(20) NULL DEFAULT NULL COMMENT '累计接驳用户数（户）',
  `store_area` decimal(20, 8) NULL DEFAULT NULL COMMENT '门店面积',
  `value_added_operating_area` decimal(20, 8) NULL DEFAULT NULL COMMENT '增值经营面积',
  `build_store_time` date NULL DEFAULT NULL COMMENT '建店时间',
  `last_rectification_time` date NULL DEFAULT NULL COMMENT '建店时间',
  `own_industry` tinyint(1) NULL DEFAULT 1 COMMENT '自有产业',
  `store_rent` decimal(20, 8) NULL DEFAULT NULL COMMENT '门店租金',
  `lease_information` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '租约信息',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE,
  INDEX `sec_bu_id_index`(`sec_bu_id`) USING BTREE,
  INDEX `sec_user_id_index`(`sec_user_id`) USING BTREE,
  INDEX `sec_ou_id_index`(`sec_ou_id`) USING BTREE
) COMMENT = '门店表' ;

-- ----------------------------
-- Table structure for org_store_to_platform
-- ----------------------------
CREATE TABLE IF NOT EXISTS `org_store_to_platform`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `store_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `store_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `platform_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `platform_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `pay_type_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `system_type` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `company_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `is_sale` int(11) NULL DEFAULT NULL,
  `is_receipt` int(11) NULL DEFAULT NULL,
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  PRIMARY KEY (`id`) USING BTREE
) COMMENT = '店铺平台关系表' ;

-- ----------------------------
-- Table structure for pri_main_price_alter
-- ----------------------------
CREATE TABLE IF NOT EXISTS `pri_main_price_alter`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  `ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'OU公司ID',
  `bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'BU组织ID',
  `doc_no` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '单据编号',
  `doc_type` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '单据类型',
  `doc_type2` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '单据类型2',
  `doc_type3` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '单据类型3',
  `doc_status` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '单据状态',
  `apply_emp_id` bigint(20) NULL DEFAULT NULL COMMENT '申请人员工ID',
  `apply_date` datetime(0) NULL DEFAULT NULL COMMENT '申请日期',
  `apply_desc` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '申请描述',
  `appr_status` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '审批状态',
  `appr_time` datetime(0) NULL DEFAULT NULL COMMENT '审批时间',
  `apply_user_id` bigint(20) NULL DEFAULT NULL COMMENT '审批人ID',
  `apply_comment` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '审批意见',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  `proc_inst_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '流程实例ID',
  `proc_inst_status` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '流程实例状态',
  `submit_time` datetime(6) NULL DEFAULT NULL COMMENT '提交时间',
  `approved_time` datetime(6) NULL DEFAULT NULL COMMENT '审批通过时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE,
  INDEX `sec_bu_id_index`(`sec_bu_id`) USING BTREE,
  INDEX `sec_user_id_index`(`sec_user_id`) USING BTREE,
  INDEX `sec_ou_id_index`(`sec_ou_id`) USING BTREE
) COMMENT = '主档价格变更单据表' ;

-- ----------------------------
-- Table structure for pri_main_price_alter_d_row
-- ----------------------------
CREATE TABLE IF NOT EXISTS `pri_main_price_alter_d_row`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  `mas_id` bigint(20) NULL DEFAULT NULL COMMENT '单据ID',
  `pri_main_price_id` bigint(20) NULL DEFAULT NULL COMMENT '商品价格表ID',
  `ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'OU公司ID',
  `ou_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'OU公司编号',
  `ou_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'OU公司名称',
  `bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'BU组织ID',
  `bu_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'BU组织编号',
  `bu_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'BU组织名称',
  `item_id` bigint(20) NULL DEFAULT NULL COMMENT '商品ID',
  `item_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '品项编号',
  `item_code2` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '第二编号',
  `item_code3` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '第三编号',
  `item_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '品项名称',
  `item_name2` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '第二名称',
  `item_name3` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '第三名称',
  `spu_id` bigint(20) NULL DEFAULT NULL COMMENT 'SPU_ID',
  `spu_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SPU_CODE',
  `spu_code2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SPU_CODE2',
  `spu_code3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SPU_CODE3',
  `spu_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SPU_NAME',
  `spu_name2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SPU_NAME2',
  `spu_name3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SPU_NAME3',
  `spec` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '一般规格，比如：食品净含量',
  `item_cate_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '品类编码',
  `uom` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '单位',
  `price_type` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '价格类型',
  `tax_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '税码',
  `tax_rate_no` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '税率编号',
  `tax_rate` decimal(20, 8) NULL DEFAULT NULL COMMENT '税率',
  `install_flag` int(11) NULL DEFAULT NULL COMMENT '是否含税',
  `price1` decimal(20, 8) NULL DEFAULT NULL COMMENT '市场价',
  `price2` decimal(20, 8) NULL DEFAULT NULL COMMENT 'B端指导价',
  `price3` decimal(20, 8) NULL DEFAULT NULL COMMENT 'C端零售价',
  `price4` decimal(20, 8) NULL DEFAULT NULL COMMENT 'B端毛利控制率',
  `price5` decimal(20, 8) NULL DEFAULT NULL COMMENT 'C端毛利控制率',
  `price6` decimal(20, 8) NULL DEFAULT NULL COMMENT 'B端毛利率',
  `price7` decimal(20, 8) NULL DEFAULT NULL COMMENT 'C端毛利率',
  `price8` decimal(20, 8) NULL DEFAULT NULL COMMENT '采购价',
  `price9` decimal(20, 8) NULL DEFAULT NULL COMMENT '价格9',
  `price10` decimal(20, 8) NULL DEFAULT NULL COMMENT '价格10',
  `curr_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '币种',
  `valid_from` datetime(6) NULL DEFAULT NULL COMMENT '生效时间',
  `valid_to` datetime(6) NULL DEFAULT NULL COMMENT '失效时间',
  `price_status` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '状态',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE,
  INDEX `sec_bu_id_index`(`sec_bu_id`) USING BTREE,
  INDEX `sec_user_id_index`(`sec_user_id`) USING BTREE,
  INDEX `sec_ou_id_index`(`sec_ou_id`) USING BTREE
) COMMENT = '主档价格变更单据明细表' ;

-- ----------------------------
-- Table structure for pri_main_price_cache
-- ----------------------------
CREATE TABLE IF NOT EXISTS `pri_main_price_cache`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
  `batch_no` bigint(20) NULL DEFAULT NULL COMMENT '批次号',
  `ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'OU公司ID',
  `ou_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'OU公司编号',
  `ou_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'OU公司名称',
  `bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'BU组织ID',
  `bu_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'BU组织编号',
  `bu_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'BU组织名称',
  `item_id` bigint(20) NULL DEFAULT NULL COMMENT '商品ID',
  `item_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '品项编号',
  `item_code2` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '第二编号',
  `item_code3` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '第三编号',
  `item_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '品项名称',
  `item_name2` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '第二名称',
  `item_name3` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '第三名称',
  `spu_id` bigint(20) NULL DEFAULT NULL COMMENT 'SPU_ID',
  `spu_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SPU_CODE',
  `spu_code2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SPU_CODE2',
  `spu_code3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SPU_CODE3',
  `spu_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SPU_NAME',
  `spu_name2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SPU_NAME2',
  `spu_name3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SPU_NAME3',
  `spec` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '一般规格，比如：食品净含量',
  `item_cate_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '品类编码',
  `uom` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '单位',
  `price_type` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '价格类型',
  `tax_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '税码',
  `tax_rate_no` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '税率编号',
  `tax_rate` decimal(20, 8) NULL DEFAULT NULL COMMENT '税率',
  `install_flag` int(11) NULL DEFAULT NULL COMMENT '是否含税',
  `price1` decimal(20, 8) NULL DEFAULT NULL COMMENT '市场价',
  `price2` decimal(20, 8) NULL DEFAULT NULL COMMENT 'B端指导价',
  `price3` decimal(20, 8) NULL DEFAULT NULL COMMENT 'C端零售价',
  `price4` decimal(20, 8) NULL DEFAULT NULL COMMENT 'B端毛利控制率',
  `price5` decimal(20, 8) NULL DEFAULT NULL COMMENT 'C端毛利控制率',
  `price6` decimal(20, 8) NULL DEFAULT NULL COMMENT 'B端毛利率',
  `price7` decimal(20, 8) NULL DEFAULT NULL COMMENT 'C端毛利率',
  `price8` decimal(20, 8) NULL DEFAULT NULL COMMENT '采购价',
  `price9` decimal(20, 8) NULL DEFAULT NULL COMMENT '价格9',
  `price10` decimal(20, 8) NULL DEFAULT NULL COMMENT '价格10',
  `curr_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '币种',
  `valid_from` datetime(6) NULL DEFAULT NULL COMMENT '生效时间',
  `valid_to` datetime(6) NULL DEFAULT NULL COMMENT '失效时间',
  `price_status` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '状态',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE
)  COMMENT = '商品主档价格导入临时存储表' ;

-- ----------------------------
-- Table structure for pri_main_price_row
-- ----------------------------
CREATE TABLE IF NOT EXISTS `pri_main_price_row`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  `ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'OU公司ID',
  `ou_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'OU公司编号',
  `ou_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'OU公司名称',
  `bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'BU组织ID',
  `bu_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'BU组织编号',
  `bu_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'BU组织名称',
  `item_id` bigint(20) NULL DEFAULT NULL COMMENT '商品ID',
  `item_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '品项编号',
  `item_code2` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '第二编号',
  `item_code3` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '第三编号',
  `item_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '品项名称',
  `item_name2` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '第二名称',
  `item_name3` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '第三名称',
  `spu_id` bigint(20) NULL DEFAULT NULL COMMENT 'SPU_ID',
  `spu_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SPU_CODE',
  `spu_code2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SPU_CODE2',
  `spu_code3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SPU_CODE3',
  `spu_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SPU_NAME',
  `spu_name2` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SPU_NAME2',
  `spu_name3` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'SPU_NAME3',
  `spec` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '一般规格，比如：食品净含量',
  `item_cate_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '品类编码',
  `uom` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '单位',
  `price_type` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '价格类型',
  `tax_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '税码',
  `tax_rate_no` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '税率编号',
  `tax_rate` decimal(20, 8) NULL DEFAULT NULL COMMENT '税率',
  `install_flag` int(11) NULL DEFAULT NULL COMMENT '是否含税',
  `price1` decimal(20, 8) NULL DEFAULT NULL COMMENT '市场价',
  `price2` decimal(20, 8) NULL DEFAULT NULL COMMENT 'B端指导价',
  `price3` decimal(20, 8) NULL DEFAULT NULL COMMENT 'C端零售价',
  `price4` decimal(20, 8) NULL DEFAULT NULL COMMENT 'B端毛利控制率',
  `price5` decimal(20, 8) NULL DEFAULT NULL COMMENT 'C端毛利控制率',
  `price6` decimal(20, 8) NULL DEFAULT NULL COMMENT 'B端毛利率',
  `price7` decimal(20, 8) NULL DEFAULT NULL COMMENT 'C端毛利率',
  `price8` decimal(20, 8) NULL DEFAULT NULL COMMENT '采购价',
  `price9` decimal(20, 8) NULL DEFAULT NULL COMMENT '价格9',
  `price10` decimal(20, 8) NULL DEFAULT NULL COMMENT '价格10',
  `curr_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '币种',
  `valid_from` datetime(6) NULL DEFAULT NULL COMMENT '生效时间',
  `valid_to` datetime(6) NULL DEFAULT NULL COMMENT '失效时间',
  `price_status` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '状态',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE,
  INDEX `sec_bu_id_index`(`sec_bu_id`) USING BTREE,
  INDEX `sec_user_id_index`(`sec_user_id`) USING BTREE,
  INDEX `sec_ou_id_index`(`sec_ou_id`) USING BTREE
) COMMENT = '商品主档价格列表' ;

-- ----------------------------
-- Table structure for sys_dp
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_dp`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `domain_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '领域编号',
  `domain_code_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '领域名称',
  `table_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '表名编码',
  `table_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '表名中文',
  `table_desc` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '表说明',
  `dp_type` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据权限类型',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  PRIMARY KEY (`id`) USING BTREE
) COMMENT = '数据权限开关' ;

-- ----------------------------
-- Table structure for sys_dp_role
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_dp_role`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `dp_role_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据权限编码',
  `dp_role_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据权限名称',
  `bu_tree_id` bigint(20) NULL DEFAULT NULL COMMENT '组织树ID',
  `enable` int(11) NULL DEFAULT 0 COMMENT '是否启用',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  PRIMARY KEY (`id`) USING BTREE
) COMMENT = '数据权限表' ;

-- ----------------------------
-- Table structure for sys_dp_role_power
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_dp_role_power`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `dp_role_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据权限编码',
  `bu_tree_id` bigint(20) NULL DEFAULT NULL COMMENT '组织树ID',
  `bu_id` bigint(20) NULL DEFAULT NULL COMMENT '组织ID',
  `bu_tree_d_id` bigint(20) NULL DEFAULT NULL COMMENT '组织树节点ID',
  `ac_type` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '访问控制类型 [UDC]USR:AC_TYPE',
  `inherit_type` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '继承类型 [UDC]USR:INHERIT_TYPE',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  PRIMARY KEY (`id`) USING BTREE
) COMMENT = '数据权限明细表' ;

-- ----------------------------
-- Table structure for sys_rocket_mq_consume_fail_log
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_rocket_mq_consume_fail_log`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `type_id` int(11) NULL DEFAULT NULL COMMENT '消费失败类型：1：消费次数过多，2：业务异常，3：长时间无法消费,4:其他',
  `already_deal` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '消费失败是否已处理；PROCESSED：已处理，TO_BE_PROCESSED:待处理',
  `consumer_key` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '消息体key',
  `consumer_boby` longblob NULL COMMENT '消息体',
  `consumer_group` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '消费者组',
  `consumer_topic` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '消费主题',
  `consumer_tag` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `message_uuid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '消息UUID',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(10) NULL DEFAULT 0 COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `UKgrpk942r3l233crbyf36p0xpx`(`consumer_key`) USING BTREE
) COMMENT = '架构补偿机制-消费失败记录' ;

-- ----------------------------
-- Table structure for sys_rocket_mq_consume_log
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_rocket_mq_consume_log`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `line_num` bigint(20) NULL DEFAULT NULL COMMENT '消息行号',
  `queue_id` int(11) NULL DEFAULT NULL COMMENT '消息体key',
  `message_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '消息标识',
  `message_uuid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '消息UUID',
  `reconsume_times` int(11) NULL DEFAULT NULL COMMENT '消息标识',
  `consumer_key` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '消息体key',
  `consumer_group` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '消费者组',
  `consumer_topic` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '消费主题',
  `is_success` int(11) NULL DEFAULT NULL COMMENT '是否消费成功:true:成功，false:失败',
  `fail_detail` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '失败详情',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(10) NULL DEFAULT 0 COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  PRIMARY KEY (`id`) USING BTREE
) COMMENT = '架构补偿机制-消费记录' ;

-- ----------------------------
-- Table structure for table_column_extensions
-- ----------------------------
CREATE TABLE IF NOT EXISTS `table_column_extensions`  (
  `id` bigint(20) NOT NULL COMMENT '记录唯一ID',
  `sec_bu_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_bu_id',
  `sec_user_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_user_id',
  `sec_ou_id` bigint(20) NULL DEFAULT NULL COMMENT 'sec_ou_id',
  `table_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '被扩展表名称',
  `column_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '被扩展列名',
  `row_id` bigint(20) NULL DEFAULT NULL COMMENT '关联行ID',
  `row_code` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '关联行编号',
  `sort_no` int(11) NULL DEFAULT NULL COMMENT '排序号',
  `column_value` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '扩展列值',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录创建者ID',
  `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录创建者',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '记录创建时间',
  `modify_user_id` bigint(20) NULL DEFAULT NULL COMMENT '记录最后更新者ID',
  `updater` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '记录最后更新者',
  `modify_time` datetime(6) NULL DEFAULT NULL COMMENT '记录最后更新时间',
  `delete_flag` int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
  `audit_data_version` int(11) NULL DEFAULT NULL COMMENT '锁版本',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `create_user_id_index`(`create_user_id`) USING BTREE,
  INDEX `sec_bu_id_index`(`sec_bu_id`) USING BTREE,
  INDEX `sec_user_id_index`(`sec_user_id`) USING BTREE,
  INDEX `sec_ou_id_index`(`sec_ou_id`) USING BTREE
) COMMENT = '表字段扩展' ;

-- ----------------------------
-- Table structure for undo_log
-- ----------------------------
CREATE TABLE IF NOT EXISTS `undo_log`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT 'increment id',
  `branch_id` bigint(20) NOT NULL COMMENT 'branch transaction id',
  `xid` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'global transaction id',
  `context` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'undo_log context,such as serialization',
  `rollback_info` longblob NOT NULL COMMENT 'rollback info',
  `log_status` int(11) NOT NULL COMMENT '0:normal status,1:defense status',
  `log_created` datetime(0) NOT NULL COMMENT 'create datetime',
  `log_modified` datetime(0) NOT NULL COMMENT 'modify datetime',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `ux_undo_log`(`xid`, `branch_id`) USING BTREE
) COMMENT = 'AT transaction mode undo table' ;

